<?php //2c28789367761449f285979dd7768289
/** @noinspection all */

namespace App\Models {

    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Notifications\DatabaseNotification;
    use Illuminate\Notifications\DatabaseNotificationCollection;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_AppointmentCategory_C;
    use LaravelIdea\Helper\App\Models\_IH_AppointmentCategory_QB;
    use LaravelIdea\Helper\App\Models\_IH_AppointmentClasses_C;
    use LaravelIdea\Helper\App\Models\_IH_AppointmentClasses_QB;
    use LaravelIdea\Helper\App\Models\_IH_AppointmentConcept_C;
    use LaravelIdea\Helper\App\Models\_IH_AppointmentConcept_QB;
    use LaravelIdea\Helper\App\Models\_IH_AppointmentPrescriptionItem_C;
    use LaravelIdea\Helper\App\Models\_IH_AppointmentPrescriptionItem_QB;
    use LaravelIdea\Helper\App\Models\_IH_AppointmentShapes_C;
    use LaravelIdea\Helper\App\Models\_IH_AppointmentShapes_QB;
    use LaravelIdea\Helper\App\Models\_IH_AppointmentStepConcept_C;
    use LaravelIdea\Helper\App\Models\_IH_AppointmentStepConcept_QB;
    use LaravelIdea\Helper\App\Models\_IH_AppointmentStep_C;
    use LaravelIdea\Helper\App\Models\_IH_AppointmentStep_QB;
    use LaravelIdea\Helper\App\Models\_IH_AppointmentTypeConcept_C;
    use LaravelIdea\Helper\App\Models\_IH_AppointmentTypeConcept_QB;
    use LaravelIdea\Helper\App\Models\_IH_AppointmentTypeStep_C;
    use LaravelIdea\Helper\App\Models\_IH_AppointmentTypeStep_QB;
    use LaravelIdea\Helper\App\Models\_IH_AppointmentType_C;
    use LaravelIdea\Helper\App\Models\_IH_AppointmentType_QB;
    use LaravelIdea\Helper\App\Models\_IH_Appointment_C;
    use LaravelIdea\Helper\App\Models\_IH_Appointment_QB;
    use LaravelIdea\Helper\App\Models\_IH_Area_C;
    use LaravelIdea\Helper\App\Models\_IH_Area_QB;
    use LaravelIdea\Helper\App\Models\_IH_Branch_C;
    use LaravelIdea\Helper\App\Models\_IH_Branch_QB;
    use LaravelIdea\Helper\App\Models\_IH_ConfigDatabase_C;
    use LaravelIdea\Helper\App\Models\_IH_ConfigDatabase_QB;
    use LaravelIdea\Helper\App\Models\_IH_PatientServer_C;
    use LaravelIdea\Helper\App\Models\_IH_PatientServer_QB;
    use LaravelIdea\Helper\App\Models\_IH_Patient_C;
    use LaravelIdea\Helper\App\Models\_IH_Patient_QB;
    use LaravelIdea\Helper\App\Models\_IH_Payment_C;
    use LaravelIdea\Helper\App\Models\_IH_Payment_QB;
    use LaravelIdea\Helper\App\Models\_IH_Product_C;
    use LaravelIdea\Helper\App\Models\_IH_Product_QB;
    use LaravelIdea\Helper\App\Models\_IH_SaleOrderLine_C;
    use LaravelIdea\Helper\App\Models\_IH_SaleOrderLine_QB;
    use LaravelIdea\Helper\App\Models\_IH_SaleOrder_C;
    use LaravelIdea\Helper\App\Models\_IH_SaleOrder_QB;
    use LaravelIdea\Helper\App\Models\_IH_SystemDiscount_C;
    use LaravelIdea\Helper\App\Models\_IH_SystemDiscount_QB;
    use LaravelIdea\Helper\App\Models\_IH_UserToken_C;
    use LaravelIdea\Helper\App\Models\_IH_UserToken_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_C;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Illuminate\Notifications\_IH_DatabaseNotification_QB;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Permission_C;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Permission_QB;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Role_C;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Role_QB;
    use Spatie\Permission\Models\Permission;
    use Spatie\Permission\Models\Role;
    
    /**
     * @property int $id
     * @property Carbon $date
     * @property Carbon $time
     * @property int|null $branch_id
     * @property int $patient_id
     * @property int|null $appointment_type_id
     * @property int|null $appointment_category_id
     * @property int|null $appointment_class_id
     * @property int|null $appointment_shape_id
     * @property string $status
     * @property string|null $note
     * @property string|null $prescription_note
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Patient $patient
     * @method BelongsTo|_IH_Patient_QB patient()
     * @property _IH_AppointmentPrescriptionItem_C|AppointmentPrescriptionItem[] $prescriptionItems
     * @property-read int $prescription_items_count
     * @method HasMany|_IH_AppointmentPrescriptionItem_QB prescriptionItems()
     * @property _IH_AppointmentStep_C|AppointmentStep[] $steps
     * @property-read int $steps_count
     * @method HasMany|_IH_AppointmentStep_QB steps()
     * @property AppointmentType|null $type
     * @method BelongsTo|_IH_AppointmentType_QB type()
     * @method static _IH_Appointment_QB onWriteConnection()
     * @method _IH_Appointment_QB newQuery()
     * @method static _IH_Appointment_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Appointment_QB query()
     * @method static _IH_Appointment_QB with(array|string $relations)
     * @method _IH_Appointment_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Appointment_C|Appointment[] all($columns = ['*'])
     * @ownLinks patient_id,\App\Models\Patient,id|branch_id,\App\Models\Branch,id|appointment_type_id,\App\Models\AppointmentType,id|appointment_category_id,\App\Models\AppointmentCategory,id|appointment_class_id,\App\Models\AppointmentClasses,id|appointment_shape_id,\App\Models\AppointmentShapes,id
     * @foreignLinks id,\App\Models\AppointmentStep,appointment_id|id,\App\Models\AppointmentPrescriptionItem,appointment_id
     * @mixin _IH_Appointment_QB
     */
    class Appointment extends Model {}
    
    /**
     * @property int $id
     * @property string|null $name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_AppointmentCategory_QB onWriteConnection()
     * @method _IH_AppointmentCategory_QB newQuery()
     * @method static _IH_AppointmentCategory_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_AppointmentCategory_QB query()
     * @method static _IH_AppointmentCategory_QB with(array|string $relations)
     * @method _IH_AppointmentCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AppointmentCategory_C|AppointmentCategory[] all($columns = ['*'])
     * @foreignLinks id,\App\Models\Appointment,appointment_category_id
     * @mixin _IH_AppointmentCategory_QB
     */
    class AppointmentCategory extends Model {}
    
    /**
     * @property int $id
     * @property string|null $name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_AppointmentClasses_QB onWriteConnection()
     * @method _IH_AppointmentClasses_QB newQuery()
     * @method static _IH_AppointmentClasses_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_AppointmentClasses_QB query()
     * @method static _IH_AppointmentClasses_QB with(array|string $relations)
     * @method _IH_AppointmentClasses_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AppointmentClasses_C|AppointmentClasses[] all($columns = ['*'])
     * @foreignLinks id,\App\Models\Appointment,appointment_class_id
     * @mixin _IH_AppointmentClasses_QB
     */
    class AppointmentClasses extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property int $area_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Area $area
     * @method BelongsTo|_IH_Area_QB area()
     * @method static _IH_AppointmentConcept_QB onWriteConnection()
     * @method _IH_AppointmentConcept_QB newQuery()
     * @method static _IH_AppointmentConcept_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_AppointmentConcept_QB query()
     * @method static _IH_AppointmentConcept_QB with(array|string $relations)
     * @method _IH_AppointmentConcept_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AppointmentConcept_C|AppointmentConcept[] all($columns = ['*'])
     * @ownLinks area_id,\App\Models\Area,id
     * @foreignLinks id,\App\Models\AppointmentTypeConcept,appointment_concept_id
     * @mixin _IH_AppointmentConcept_QB
     */
    class AppointmentConcept extends Model {}
    
    /**
     * @property int $id
     * @property int $appointment_id
     * @property string|null $product
     * @property string|null $instructions
     * @property bool $bought
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_AppointmentPrescriptionItem_QB onWriteConnection()
     * @method _IH_AppointmentPrescriptionItem_QB newQuery()
     * @method static _IH_AppointmentPrescriptionItem_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_AppointmentPrescriptionItem_QB query()
     * @method static _IH_AppointmentPrescriptionItem_QB with(array|string $relations)
     * @method _IH_AppointmentPrescriptionItem_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AppointmentPrescriptionItem_C|AppointmentPrescriptionItem[] all($columns = ['*'])
     * @ownLinks appointment_id,\App\Models\Appointment,id
     * @mixin _IH_AppointmentPrescriptionItem_QB
     */
    class AppointmentPrescriptionItem extends Model {}
    
    /**
     * @property int $id
     * @property string|null $name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_AppointmentShapes_QB onWriteConnection()
     * @method _IH_AppointmentShapes_QB newQuery()
     * @method static _IH_AppointmentShapes_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_AppointmentShapes_QB query()
     * @method static _IH_AppointmentShapes_QB with(array|string $relations)
     * @method _IH_AppointmentShapes_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AppointmentShapes_C|AppointmentShapes[] all($columns = ['*'])
     * @foreignLinks id,\App\Models\Appointment,appointment_shape_id
     * @mixin _IH_AppointmentShapes_QB
     */
    class AppointmentShapes extends Model {}
    
    /**
     * @property int $id
     * @property int $appointment_id
     * @property string $name
     * @property int $expected_time
     * @property int|null $order
     * @property Carbon|null $start_at
     * @property Carbon|null $end_at
     * @property int $real_time
     * @property string $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_AppointmentStep_QB onWriteConnection()
     * @method _IH_AppointmentStep_QB newQuery()
     * @method static _IH_AppointmentStep_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_AppointmentStep_QB query()
     * @method static _IH_AppointmentStep_QB with(array|string $relations)
     * @method _IH_AppointmentStep_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AppointmentStep_C|AppointmentStep[] all($columns = ['*'])
     * @ownLinks appointment_id,\App\Models\Appointment,id
     * @mixin _IH_AppointmentStep_QB
     */
    class AppointmentStep extends Model {}
    
    /**
     * @property AppointmentConcept $appointmentConcept
     * @method BelongsTo|_IH_AppointmentConcept_QB appointmentConcept()
     * @method static _IH_AppointmentStepConcept_QB onWriteConnection()
     * @method _IH_AppointmentStepConcept_QB newQuery()
     * @method static _IH_AppointmentStepConcept_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_AppointmentStepConcept_QB query()
     * @method static _IH_AppointmentStepConcept_QB with(array|string $relations)
     * @method _IH_AppointmentStepConcept_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AppointmentStepConcept_C|AppointmentStepConcept[] all($columns = ['*'])
     * @mixin _IH_AppointmentStepConcept_QB
     */
    class AppointmentStepConcept extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property int $related_product_id
     * @property bool $active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Product $product
     * @method HasOne|_IH_Product_QB product()
     * @property _IH_AppointmentTypeStep_C|AppointmentTypeStep[] $steps
     * @property-read int $steps_count
     * @method HasMany|_IH_AppointmentTypeStep_QB steps()
     * @method static _IH_AppointmentType_QB onWriteConnection()
     * @method _IH_AppointmentType_QB newQuery()
     * @method static _IH_AppointmentType_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_AppointmentType_QB query()
     * @method static _IH_AppointmentType_QB with(array|string $relations)
     * @method _IH_AppointmentType_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AppointmentType_C|AppointmentType[] all($columns = ['*'])
     * @foreignLinks id,\App\Models\AppointmentTypeStep,appointment_type_id|id,\App\Models\Appointment,appointment_type_id|id,\App\Models\AppointmentTypeConcept,appointment_type_id
     * @mixin _IH_AppointmentType_QB
     */
    class AppointmentType extends Model {}
    
    /**
     * @property int $id
     * @property int $appointment_type_id
     * @property int $appointment_concept_id
     * @property float $expected_time
     * @property float $maximum_time
     * @property bool $enabled
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property AppointmentConcept $appointmentConcept
     * @method BelongsTo|_IH_AppointmentConcept_QB appointmentConcept()
     * @property AppointmentType $appointmentType
     * @method BelongsTo|_IH_AppointmentType_QB appointmentType()
     * @method static _IH_AppointmentTypeConcept_QB onWriteConnection()
     * @method _IH_AppointmentTypeConcept_QB newQuery()
     * @method static _IH_AppointmentTypeConcept_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_AppointmentTypeConcept_QB query()
     * @method static _IH_AppointmentTypeConcept_QB with(array|string $relations)
     * @method _IH_AppointmentTypeConcept_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AppointmentTypeConcept_C|AppointmentTypeConcept[] all($columns = ['*'])
     * @ownLinks appointment_type_id,\App\Models\AppointmentType,id|appointment_concept_id,\App\Models\AppointmentConcept,id
     * @mixin _IH_AppointmentTypeConcept_QB
     */
    class AppointmentTypeConcept extends Model {}
    
    /**
     * @property int $id
     * @property int $appointment_type_id
     * @property string $name
     * @property int $expected_time
     * @property int|null $order
     * @property bool|null $minimum_required
     * @property bool $active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $area_id
     * @property int|null $minimum_time
     * @property int|null $maximum_time
     * @method static _IH_AppointmentTypeStep_QB onWriteConnection()
     * @method _IH_AppointmentTypeStep_QB newQuery()
     * @method static _IH_AppointmentTypeStep_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_AppointmentTypeStep_QB query()
     * @method static _IH_AppointmentTypeStep_QB with(array|string $relations)
     * @method _IH_AppointmentTypeStep_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AppointmentTypeStep_C|AppointmentTypeStep[] all($columns = ['*'])
     * @ownLinks appointment_type_id,\App\Models\AppointmentType,id|area_id,\App\Models\Area,id
     * @mixin _IH_AppointmentTypeStep_QB
     */
    class AppointmentTypeStep extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Area_QB onWriteConnection()
     * @method _IH_Area_QB newQuery()
     * @method static _IH_Area_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Area_QB query()
     * @method static _IH_Area_QB with(array|string $relations)
     * @method _IH_Area_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Area_C|Area[] all($columns = ['*'])
     * @foreignLinks id,\App\Models\AppointmentTypeStep,area_id|id,\App\Models\AppointmentConcept,area_id
     * @mixin _IH_Area_QB
     */
    class Area extends Model {}
    
    /**
     * @property int $id
     * @property string|null $name
     * @property string|null $address
     * @property string|null $address2
     * @property string|null $city
     * @property string|null $state
     * @property string $country
     * @property string|null $zip
     * @property string|null $phone
     * @property string|null $email
     * @property string|null $invoice_prefix
     * @property string|null $sale_order_prefix
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Branch_QB onWriteConnection()
     * @method _IH_Branch_QB newQuery()
     * @method static _IH_Branch_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Branch_QB query()
     * @method static _IH_Branch_QB with(array|string $relations)
     * @method _IH_Branch_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Branch_C|Branch[] all($columns = ['*'])
     * @foreignLinks id,\App\Models\User,branch_id|id,\App\Models\Appointment,branch_id|id,\App\Models\SaleOrder,branch_id
     * @mixin _IH_Branch_QB
     */
    class Branch extends Model {}
    
    /**
     * @property int $id
     * @property string $host
     * @property string $database
     * @property string|null $client_id
     * @property string|null $client_secret
     * @property Carbon|null $deleted_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_ConfigDatabase_QB onWriteConnection()
     * @method _IH_ConfigDatabase_QB newQuery()
     * @method static _IH_ConfigDatabase_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_ConfigDatabase_QB query()
     * @method static _IH_ConfigDatabase_QB with(array|string $relations)
     * @method _IH_ConfigDatabase_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ConfigDatabase_C|ConfigDatabase[] all($columns = ['*'])
     * @mixin _IH_ConfigDatabase_QB
     */
    class ConfigDatabase extends Model {}
    
    /**
     * @property int $id
     * @property string|null $name
     * @property Carbon|null $birthday
     * @property int|null $profession
     * @property string $gender
     * @property string|null $company_name
     * @property string $tin
     * @property string|null $street
     * @property string|null $street2
     * @property string|null $city
     * @property string|null $state
     * @property string|null $country
     * @property string|null $phone
     * @property string|null $mobile
     * @property string|null $email
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_PatientServer_C|PatientServer[] $server
     * @property-read int $server_count
     * @method HasMany|_IH_PatientServer_QB server()
     * @method static _IH_Patient_QB onWriteConnection()
     * @method _IH_Patient_QB newQuery()
     * @method static _IH_Patient_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Patient_QB query()
     * @method static _IH_Patient_QB with(array|string $relations)
     * @method _IH_Patient_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Patient_C|Patient[] all($columns = ['*'])
     * @foreignLinks id,\App\Models\Appointment,patient_id|id,\App\Models\PatientServer,patient_id|id,\App\Models\SaleOrder,patient_id
     * @mixin _IH_Patient_QB
     */
    class Patient extends Model {}
    
    /**
     * @property int $id
     * @property int|null $patient_id
     * @property int|null $database_id
     * @property int|null $api_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_PatientServer_QB onWriteConnection()
     * @method _IH_PatientServer_QB newQuery()
     * @method static _IH_PatientServer_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_PatientServer_QB query()
     * @method static _IH_PatientServer_QB with(array|string $relations)
     * @method _IH_PatientServer_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PatientServer_C|PatientServer[] all($columns = ['*'])
     * @ownLinks patient_id,\App\Models\Patient,id
     * @mixin _IH_PatientServer_QB
     */
    class PatientServer extends Model {}
    
    /**
     * @property int $id
     * @property int|null $sale_order_id
     * @property int|null $user_id
     * @property string $type
     * @property float $amount
     * @property string $method
     * @property string|null $reference
     * @property string $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property SaleOrder|null $saleOrder
     * @method BelongsTo|_IH_SaleOrder_QB saleOrder()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Payment_QB onWriteConnection()
     * @method _IH_Payment_QB newQuery()
     * @method static _IH_Payment_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Payment_QB query()
     * @method static _IH_Payment_QB with(array|string $relations)
     * @method _IH_Payment_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Payment_C|Payment[] all($columns = ['*'])
     * @ownLinks sale_order_id,\App\Models\SaleOrder,id|user_id,\App\Models\User,id
     * @mixin _IH_Payment_QB
     */
    class Payment extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property float|null $list_price
     * @property bool $taxes
     * @property bool $active
     * @property int|null $odoo_server
     * @property string|null $odoo_product_id
     * @property int $business_unit_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property ConfigDatabase|null $server
     * @method HasOne|_IH_ConfigDatabase_QB server()
     * @method static _IH_Product_QB onWriteConnection()
     * @method _IH_Product_QB newQuery()
     * @method static _IH_Product_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Product_QB query()
     * @method static _IH_Product_QB with(array|string $relations)
     * @method _IH_Product_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Product_C|Product[] all($columns = ['*'])
     * @foreignLinks id,\App\Models\SaleOrderLine,product_id
     * @mixin _IH_Product_QB
     */
    class Product extends Model {}
    
    /**
     * @property int $id
     * @property Carbon|null $date
     * @property string|null $number
     * @property bool $first_time
     * @property int|null $patient_id
     * @property int|null $branch_id
     * @property float $subtotal
     * @property float $discount
     * @property float $tax
     * @property float $total
     * @property string $payment_status
     * @property int|null $odoo_server
     * @property string|null $odoo_sale_order_id
     * @property string|null $odoo_sale_order_number
     * @property int|null $created_by
     * @property string|null $created_by_name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_SaleOrderLine_C|SaleOrderLine[] $lines
     * @property-read int $lines_count
     * @method HasMany|_IH_SaleOrderLine_QB lines()
     * @property Patient|null $patient
     * @method BelongsTo|_IH_Patient_QB patient()
     * @property _IH_Payment_C|Payment[] $payments
     * @property-read int $payments_count
     * @method HasMany|_IH_Payment_QB payments()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_SaleOrder_QB onWriteConnection()
     * @method _IH_SaleOrder_QB newQuery()
     * @method static _IH_SaleOrder_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_SaleOrder_QB query()
     * @method static _IH_SaleOrder_QB with(array|string $relations)
     * @method _IH_SaleOrder_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SaleOrder_C|SaleOrder[] all($columns = ['*'])
     * @ownLinks patient_id,\App\Models\Patient,id|branch_id,\App\Models\Branch,id
     * @foreignLinks id,\App\Models\SaleOrderLine,sale_order_id|id,\App\Models\Payment,sale_order_id
     * @mixin _IH_SaleOrder_QB
     */
    class SaleOrder extends Model {}
    
    /**
     * @property int $id
     * @property int $sale_order_id
     * @property int|null $product_id
     * @property string|null $product_name
     * @property int $quantity
     * @property float $price
     * @property float $discount
     * @property float $tax
     * @property float $amount
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Product|null $product
     * @method HasOne|_IH_Product_QB product()
     * @property SaleOrder $saleOrder
     * @method BelongsTo|_IH_SaleOrder_QB saleOrder()
     * @method static _IH_SaleOrderLine_QB onWriteConnection()
     * @method _IH_SaleOrderLine_QB newQuery()
     * @method static _IH_SaleOrderLine_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_SaleOrderLine_QB query()
     * @method static _IH_SaleOrderLine_QB with(array|string $relations)
     * @method _IH_SaleOrderLine_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SaleOrderLine_C|SaleOrderLine[] all($columns = ['*'])
     * @ownLinks sale_order_id,\App\Models\SaleOrder,id|product_id,\App\Models\Product,id
     * @mixin _IH_SaleOrderLine_QB
     */
    class SaleOrderLine extends Model {}
    
    /**
     * @property int $id
     * @property int $value
     * @property string|null $label
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_SystemDiscount_QB onWriteConnection()
     * @method _IH_SystemDiscount_QB newQuery()
     * @method static _IH_SystemDiscount_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_SystemDiscount_QB query()
     * @method static _IH_SystemDiscount_QB with(array|string $relations)
     * @method _IH_SystemDiscount_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SystemDiscount_C|SystemDiscount[] all($columns = ['*'])
     * @mixin _IH_SystemDiscount_QB
     */
    class SystemDiscount extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property bool $is_doctor
     * @property int|null $branch_id
     * @property string $email
     * @property Carbon|null $email_verified_at
     * @property string $password
     * @property string|null $odoo_password
     * @property string|null $remember_token
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Branch|null $branch
     * @method BelongsTo|_IH_Branch_QB branch()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $notifications
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property _IH_Permission_C|Permission[] $permissions
     * @property-read int $permissions_count
     * @method MorphToMany|_IH_Permission_QB permissions()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @property _IH_Role_C|Role[] $roles
     * @property-read int $roles_count
     * @method MorphToMany|_IH_Role_QB roles()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @method static _IH_User_QB onWriteConnection()
     * @method _IH_User_QB newQuery()
     * @method static _IH_User_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_User_QB query()
     * @method static _IH_User_QB with(array|string $relations)
     * @method _IH_User_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_User_C|User[] all($columns = ['*'])
     * @ownLinks branch_id,\App\Models\Branch,id
     * @foreignLinks id,\App\Models\UserToken,user_id|id,\App\Models\Payment,user_id
     * @mixin _IH_User_QB
     */
    class User extends Model {}
    
    /**
     * @property int $id
     * @property int|null $user_id
     * @property string|null $server_id
     * @property string|null $access_token
     * @property Carbon|null $expires_at
     * @property string|null $refreshToken
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_UserToken_QB onWriteConnection()
     * @method _IH_UserToken_QB newQuery()
     * @method static _IH_UserToken_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_UserToken_QB query()
     * @method static _IH_UserToken_QB with(array|string $relations)
     * @method _IH_UserToken_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserToken_C|UserToken[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_UserToken_QB
     */
    class UserToken extends Model {}
}