<?php //353a94f8148d46dd0e902deaa9cc26c5
/** @noinspection all */

namespace Illuminate\Contracts\View {
    
    /**
     * @method $this extends($view, $params = [])
     * @method $this layout($view, $params = [])
     * @method $this layoutData($data = [])
     * @method $this response(callable $callback)
     * @method $this section($section)
     * @method $this slot($slot)
     * @method $this title($title)
     */
    class View {}
}

namespace Illuminate\Database\Eloquent {

    use Illuminate\Contracts\Database\Query\Expression;
    use Illuminate\Database\Query\Builder as QueryBuilder;
    use Illuminate\Support\HigherOrderTapProxy;
    use Kirschbaum\PowerJoins\PowerJoinClause;
    
    /**
     * @method Model|HigherOrderTapProxy createOrRestore(array $attributes = [], array $values = [])
     * @method array getAllGlobalScopes()
     * @method array|mixed getGroupBy()
     * @method array getScopes()
     * @method Expression[]|mixed|string[] getSelect()
     * @method $this hasNestedUsingJoins(string $relations, string $operator = '>=', int $count = 1, string $boolean = 'and', array|\Closure|null|string $callback = null)
     * @method $this joinNestedRelationship(string $relationships, array|\Closure|null|string $callback = null, string $joinType = 'join', bool $useAlias = false, bool $disableExtraConditions = false, null|string $morphable = null)
     * @method $this joinRelation(string $relationName, array|\Closure|null|string $callback = null, string $joinType = 'join', bool $useAlias = false, bool $disableExtraConditions = false, null|string $morphable = null)
     * @method $this joinRelationship(string $relationName, array|\Closure|null|string $callback = null, string $joinType = 'join', bool $useAlias = false, bool $disableExtraConditions = false, null|string $morphable = null)
     * @method $this joinRelationshipUsingAlias(string $relationName, array|\Closure|null|string $callback = null, bool $disableExtraConditions = false, null|string $morphable = null)
     * @method $this leftJoinRelation(string $relation, array|\Closure|null|string $callback = null, bool $useAlias = false, bool $disableExtraConditions = false, null|string $morphable = null)
     * @method $this leftJoinRelationship(string $relationName, array|\Closure|null|string $callback = null, bool $useAlias = false, bool $disableExtraConditions = false, null|string $morphable = null)
     * @method $this leftJoinRelationshipUsingAlias(string $relationName, array|\Closure|null|string $callback = null, bool $disableExtraConditions = false, null|string $morphable = null)
     * @method $this leftPowerJoin($table, $first, $operator = null, $second = null)
     * @method PowerJoinClause newPowerJoinClause(QueryBuilder $parentQuery, string $type, string $table, Model|null $model = null)
     * @method $this onlyTrashed()
     * @method $this orderByLeftPowerJoins(array|string $sort, string $direction = 'asc')
     * @method $this orderByLeftPowerJoinsAvg(array|string $sort, string $direction = 'asc')
     * @method $this orderByLeftPowerJoinsCount(array|string $sort, string $direction = 'asc')
     * @method $this orderByLeftPowerJoinsMax(array|string $sort, string $direction = 'asc')
     * @method $this orderByLeftPowerJoinsMin(array|string $sort, string $direction = 'asc')
     * @method $this orderByLeftPowerJoinsSum(array|string $sort, string $direction = 'asc')
     * @method $this orderByPowerJoins(array|string $sort, string $direction = 'asc', null|string $aggregation = null, string $joinType = 'join', $aliases = null)
     * @method $this orderByPowerJoinsAvg(array|string $sort, string $direction = 'asc')
     * @method $this orderByPowerJoinsCount(array|string $sort, string $direction = 'asc')
     * @method $this orderByPowerJoinsMax(array|string $sort, string $direction = 'asc')
     * @method $this orderByPowerJoinsMin(array|string $sort, string $direction = 'asc')
     * @method $this orderByPowerJoinsSum(array|string $sort, string $direction = 'asc')
     * @method $this powerJoin($table, $first, $operator = null, $second = null, $type = 'inner', $where = false)
     * @method $this powerJoinDoesntHave($relation, $boolean = 'and', \Closure|null $callback = null)
     * @method $this powerJoinHas(string $relation, string $operator = '>=', int $count = 1, $boolean = 'and', array|\Closure|null|string $callback = null, null|string $morphable = null)
     * @method $this powerJoinWhereHas($relation, $callback = null, $operator = '>=', $count = 1)
     * @method int restore()
     * @method Model|HigherOrderTapProxy restoreOrCreate(array $attributes = [], array $values = [])
     * @method $this rightJoinRelation(string $relation, array|\Closure|null|string $callback = null, bool $useAlias = false, bool $disableExtraConditions = false, null|string $morphable = null)
     * @method $this rightJoinRelationship(string $relation, array|\Closure|null|string $callback = null, bool $useAlias = false, bool $disableExtraConditions = false, null|string $morphable = null)
     * @method $this rightJoinRelationshipUsingAlias(string $relationName, array|\Closure|null|string $callback = null, bool $disableExtraConditions = false, null|string $morphable = null)
     * @method $this rightPowerJoin($table, $first, $operator = null, $second = null)
     * @method $this withTrashed($withTrashed = true)
     * @method $this withoutTrashed()
     */
    class Builder {}
}

namespace Illuminate\Database\Eloquent\Relations {

    use Illuminate\Database\Eloquent\Model;
    use Kirschbaum\PowerJoins\PowerJoinClause;
    
    /**
     * @method void applyBasicCondition($join, $condition)
     * @method void applyExtraConditions(PowerJoinClause $join)
     * @method void applyNestedCondition($join, $condition)
     * @method void applyNotNullCondition($join, $condition)
     * @method void applyNullCondition($join, $condition)
     * @method array|mixed exportExtraParametersForSerialize()
     * @method Model getFarParent()
     * @method array|string|void getPowerJoinExistenceCompareKey()
     * @method Model getThroughParent()
     * @method void importExtraParametersForSerialize(array $params)
     * @method void performHavingForEloquentPowerJoins($builder, $operator, $count, null|string $morphable = null)
     * @method \Closure performJoinForEloquentPowerJoins($builder, $joinType = 'leftJoin', $callback = null, $alias = null, bool $disableExtraConditions = false, null|string $morphable = null, bool $hasCheck = false)
     * @method bool shouldNotApplyExtraCondition($condition)
     * @method bool usesSoftDeletes($model)
     */
    class Relation {}
}

namespace Illuminate\Database\Query {

    use Illuminate\Contracts\Database\Query\Expression;
    
    /**
     * @method array|mixed getGroupBy()
     * @method Expression[]|mixed|string[] getSelect()
     */
    class Builder {}
}

namespace Illuminate\Redis {
    
    /**
     * @mixin \Illuminate\Redis\Connections\PhpRedisConnection
     * @mixin \Redis
     */
    class RedisManager {}
}

namespace Illuminate\Routing {
    
    /**
     * @method $this lazy($enabled = true)
     * @method $this|array permission($permissions = [])
     * @method $this|array role($roles = [])
     */
    class Route {}
    
    /**
     * @method void auth($options = [])
     * @method void confirmPassword()
     * @method void emailVerification()
     * @method void resetPassword()
     */
    class Router {}
}

namespace Illuminate\Support {
    
    /**
     * @method string sanitizeHtml(string $html)
     * @method string ucwords(string $value)
     */
    class Str {}
    
    /**
     * @method $this sanitizeHtml()
     * @method $this ucwords()
     */
    class Stringable {}
}

namespace Illuminate\Testing {
    
    /**
     * @method $this assertDontSeeLivewire($component)
     * @method $this assertDontSeeVolt($component)
     * @method $this assertSeeLivewire($component)
     * @method $this assertSeeVolt($component)
     */
    class TestResponse {}
    
    /**
     * @method $this assertDontSeeLivewire($component)
     * @method $this assertSeeLivewire($component)
     */
    class TestView {}
}

namespace Illuminate\View {

    use Livewire\WireDirective;
    
    /**
     * @method WireDirective wire($name)
     */
    class ComponentAttributeBag {}
    
    /**
     * @method $this extends($view, $params = [])
     * @method $this layout($view, $params = [])
     * @method $this layoutData($data = [])
     * @method $this response(callable $callback)
     * @method $this section($section)
     * @method $this slot($slot)
     * @method $this title($title)
     */
    class View {}
}

namespace Laravel\Dusk {
    
    /**
     * @method $this assertAttributeMissing($selector, $attribute)
     * @method $this assertClassMissing($selector, $className)
     * @method $this assertConsoleLogHasErrors()
     * @method $this assertConsoleLogHasNoErrors()
     * @method $this|void assertConsoleLogHasWarning($expectedMessage)
     * @method $this|void assertConsoleLogMissingWarning($expectedMessage)
     * @method $this assertHasClass($selector, $className)
     * @method $this|void assertInViewPort($selector, $invert = false)
     * @method \Closure assertNotInViewPort($selector)
     * @method $this|void assertNotPresent($selector)
     * @method $this|void assertNotVisible($selector)
     * @method $this|void assertScript($js, $expects = true)
     * @method mixed offline()
     * @method mixed online()
     * @method $this runScript($js)
     * @method $this scrollTo($selector)
     * @method $this selectMultiple($field, $values = [])
     * @method object waitForLivewire($callback = null)
     * @method mixed waitForLivewireToLoad()
     * @method object waitForNavigate($callback = null)
     * @method object waitForNavigatePrefetchRequest($callback = null)
     * @method object waitForNavigateRequest($callback = null)
     * @method object waitForNoLivewire($callback = null)
     * @method object waitForNoNavigatePrefetchRequest($callback = null, $prefetchDelay = 70)
     * @method object waitForNoNavigateRequest($callback = null)
     */
    class Browser {}
}

namespace Livewire\Features\SupportTesting {

    use Filament\Notifications\Notification;
    use Illuminate\Support\Collection;
    
    /**
     * @method $this assertActionListInOrder(array $names, array $actions, string $actionType, string $actionClass)
     * @method $this assertCanNotRenderTableColumn(string $name)
     * @method $this assertCanNotSeeTableRecords(array|Collection $records)
     * @method $this assertCanRenderTableColumn(string $name)
     * @method $this assertCanSeeTableRecords(array|Collection $records, bool $inOrder = false)
     * @method $this assertCountTableRecords(int $count)
     * @method $this assertFormComponentActionDataSet(array $data)
     * @method $this assertFormComponentActionDisabled(array|string $component, array|string $name, array $arguments = [], string $formName = 'form')
     * @method $this assertFormComponentActionDoesNotExist(array|string $component, array|string $name, string $formName = 'form')
     * @method $this assertFormComponentActionDoesNotHaveColor(array|string $component, array|string $name, array|string $color, array $arguments = [], string $formName = 'form')
     * @method $this assertFormComponentActionDoesNotHaveIcon(array|string $component, array|string $name, string $icon, array $arguments = [], string $formName = 'form')
     * @method $this assertFormComponentActionDoesNotHaveLabel(array|string $component, array|string $name, string $label, array $arguments = [], string $formName = 'form')
     * @method $this assertFormComponentActionDoesNotHaveUrl(array|string $component, array|string $name, string $url, array $arguments = [], string $formName = 'form')
     * @method $this assertFormComponentActionEnabled(array|string $component, array|string $name, array $arguments = [], string $formName = 'form')
     * @method $this assertFormComponentActionExists(array|string $component, array|string $name, string $formName = 'form')
     * @method $this assertFormComponentActionHasColor(array|string $component, array|string $name, array|string $color, array $arguments = [], string $formName = 'form')
     * @method $this assertFormComponentActionHasIcon(array|string $component, array|string $name, string $icon, array $arguments = [], string $formName = 'form')
     * @method $this assertFormComponentActionHasLabel(array|string $component, array|string $name, string $label, array $arguments = [], string $formName = 'form')
     * @method $this assertFormComponentActionHasUrl(array|string $component, array|string $name, string $url, array $arguments = [], string $formName = 'form')
     * @method $this assertFormComponentActionHidden(array|string $component, array|string $name, array $arguments = [], string $formName = 'form')
     * @method $this assertFormComponentActionMounted(array|string $component, array|string $name, string $formName = 'form')
     * @method $this assertFormComponentActionNotMounted(array|string $component, array|string $name, string $formName = 'form')
     * @method $this assertFormComponentActionShouldNotOpenUrlInNewTab(array|string $component, array|string $name, array $arguments = [], string $formName = 'form')
     * @method $this assertFormComponentActionShouldOpenUrlInNewTab(array|string $component, array|string $name, array $arguments = [], string $formName = 'form')
     * @method $this assertFormComponentActionVisible(array|string $component, array|string $name, array $arguments = [], string $formName = 'form')
     * @method $this assertFormComponentDoesNotExist(string $componentKey, string $formName = 'form')
     * @method $this assertFormComponentExists(string $componentKey, \Closure|string $formName = 'form', \Closure|null $checkComponentUsing = null)
     * @method $this assertFormExists(string $name = 'form')
     * @method $this assertFormFieldDoesNotExist(string $fieldName, string $formName = 'form')
     * @method $this assertFormFieldExists(string $fieldName, \Closure|string $formName = 'form', \Closure|null $checkFieldUsing = null)
     * @method $this assertFormFieldIsDisabled(string $fieldName, string $formName = 'form')
     * @method $this assertFormFieldIsEnabled(string $fieldName, string $formName = 'form')
     * @method $this assertFormFieldIsHidden(string $fieldName, string $formName = 'form')
     * @method $this assertFormFieldIsReadOnly(string $fieldName, string $formName = 'form')
     * @method $this assertFormFieldIsVisible(string $fieldName, string $formName = 'form')
     * @method $this assertFormSet(array|\Closure $state, string $formName = 'form')
     * @method $this assertHasFormComponentActionErrors(array $keys = [])
     * @method $this assertHasFormErrors(array $keys = [], string $formName = 'form')
     * @method $this assertHasInfolistActionErrors(array $keys = [])
     * @method $this assertHasNoFormComponentActionErrors(array $keys = [])
     * @method $this assertHasNoFormErrors(array $keys = [], string $formName = 'form')
     * @method $this assertHasNoInfolistActionErrors(array $keys = [])
     * @method $this assertHasNoTableActionErrors(array $keys = [])
     * @method $this assertHasNoTableBulkActionErrors(array $keys = [])
     * @method $this assertHasTableActionErrors(array $keys = [])
     * @method $this assertHasTableBulkActionErrors(array $keys = [])
     * @method $this assertInfolistActionDataSet(array $data)
     * @method $this assertInfolistActionDisabled(string $component, array|string $name, string $infolistName = 'infolist')
     * @method $this assertInfolistActionDoesNotExist(string $component, array|string $name, string $infolistName = 'infolist')
     * @method $this assertInfolistActionDoesNotHaveColor(string $component, array|string $name, array|string $color, string $infolistName = 'infolist')
     * @method $this assertInfolistActionDoesNotHaveIcon(string $component, array|string $name, string $icon, string $infolistName = 'infolist')
     * @method $this assertInfolistActionDoesNotHaveLabel(string $component, array|string $name, string $label, string $infolistName = 'infolist')
     * @method $this assertInfolistActionDoesNotHaveUrl(string $component, array|string $name, string $url, string $infolistName = 'infolist')
     * @method $this assertInfolistActionEnabled(string $component, array|string $name, string $infolistName = 'infolist')
     * @method $this assertInfolistActionExists(string $component, array|string $name, string $infolistName = 'infolist')
     * @method $this assertInfolistActionHasColor(string $component, array|string $name, array|string $color, string $infolistName = 'infolist')
     * @method $this assertInfolistActionHasIcon(string $component, array|string $name, string $icon, string $infolistName = 'infolist')
     * @method $this assertInfolistActionHasLabel(string $component, array|string $name, string $label, string $infolistName = 'infolist')
     * @method $this assertInfolistActionHasUrl(string $component, array|string $name, string $url, string $infolistName = 'infolist')
     * @method $this assertInfolistActionHidden(string $component, array|string $name, string $infolistName = 'infolist')
     * @method $this assertInfolistActionMounted(string $component, array|string $name, string $infolistName = 'infolist')
     * @method $this assertInfolistActionNotMounted(string $component, array|string $name, string $infolistName = 'infolist')
     * @method $this assertInfolistActionShouldNotOpenUrlInNewTab(string $component, array|string $name, string $infolistName = 'infolist')
     * @method $this assertInfolistActionShouldOpenUrlInNewTab(string $component, array|string $name, string $infolistName = 'infolist')
     * @method $this assertInfolistActionVisible(string $component, array|string $name, string $infolistName = 'infolist')
     * @method $this assertNotNotified(Notification|null|string $notification = null)
     * @method $this assertNotified(Notification|null|string $notification = null)
     * @method $this assertTableActionDataSet(array|\Closure $state)
     * @method $this assertTableActionDisabled(array|string $name, $record = null)
     * @method $this assertTableActionDoesNotExist(array|string $name, \Closure|null $checkActionUsing = null, $record = null)
     * @method $this assertTableActionDoesNotHaveColor(array|string $name, array|string $color, $record = null)
     * @method $this assertTableActionDoesNotHaveIcon(array|string $name, string $icon, $record = null)
     * @method $this assertTableActionDoesNotHaveLabel(array|string $name, string $label, $record = null)
     * @method $this assertTableActionDoesNotHaveUrl(array|string $name, string $url, $record = null)
     * @method $this assertTableActionEnabled(array|string $name, $record = null)
     * @method $this assertTableActionExists(array|string $name, \Closure|null $checkActionUsing = null, $record = null)
     * @method $this assertTableActionHasColor(array|string $name, array|string $color, $record = null)
     * @method $this assertTableActionHasIcon(array|string $name, string $icon, $record = null)
     * @method $this assertTableActionHasLabel(array|string $name, string $label, $record = null)
     * @method $this assertTableActionHasUrl(array|string $name, string $url, $record = null)
     * @method $this assertTableActionHidden(array|string $name, $record = null)
     * @method $this assertTableActionMounted(array|string $name)
     * @method $this assertTableActionNotMounted(array|string $name)
     * @method $this assertTableActionShouldNotOpenUrlInNewTab(array|string $name, $record = null)
     * @method $this assertTableActionShouldOpenUrlInNewTab(array|string $name, $record = null)
     * @method $this assertTableActionVisible(array|string $name, $record = null)
     * @method $this assertTableActionsExistInOrder(array $names)
     * @method $this assertTableBulkActionDataSet(array|\Closure $state)
     * @method $this assertTableBulkActionDisabled(string $name)
     * @method $this assertTableBulkActionDoesNotExist(string $name)
     * @method $this assertTableBulkActionDoesNotHaveColor(string $name, array|string $color, $record = null)
     * @method $this assertTableBulkActionDoesNotHaveIcon(string $name, string $icon, $record = null)
     * @method $this assertTableBulkActionDoesNotHaveLabel(string $name, string $label, $record = null)
     * @method $this assertTableBulkActionEnabled(string $name)
     * @method $this assertTableBulkActionExists(string $name)
     * @method $this assertTableBulkActionHasColor(string $name, array|string $color, $record = null)
     * @method $this assertTableBulkActionHasIcon(string $name, string $icon, $record = null)
     * @method $this assertTableBulkActionHasLabel(string $name, string $label, $record = null)
     * @method $this assertTableBulkActionHidden(string $name)
     * @method $this assertTableBulkActionMounted(string $name)
     * @method $this assertTableBulkActionNotMounted(string $name)
     * @method $this assertTableBulkActionVisible(string $name)
     * @method $this assertTableBulkActionsExistInOrder(array $names)
     * @method $this assertTableColumnDoesNotExist(string $name, \Closure|null $checkColumnUsing = null, $record = null)
     * @method $this|void assertTableColumnDoesNotHaveDescription(string $name, $description, $record, string $position = 'below')
     * @method $this|void assertTableColumnDoesNotHaveExtraAttributes(string $name, array $attributes, $record)
     * @method $this assertTableColumnExists(string $name, \Closure|null $checkColumnUsing = null, $record = null)
     * @method $this assertTableColumnFormattedStateNotSet(string $name, $value, $record)
     * @method $this assertTableColumnFormattedStateSet(string $name, $value, $record)
     * @method $this|void assertTableColumnHasDescription(string $name, $description, $record, string $position = 'below')
     * @method $this|void assertTableColumnHasExtraAttributes(string $name, array $attributes, $record)
     * @method $this assertTableColumnHidden(string $name)
     * @method $this assertTableColumnStateNotSet(string $name, $value, $record)
     * @method $this assertTableColumnStateSet(string $name, $value, $record)
     * @method $this assertTableColumnSummarizerExists(string $columnName, string $summarizerId)
     * @method $this assertTableColumnSummaryNotSet(string $columnName, string $summarizerId, $state, bool $isCurrentPaginationPageOnly = false)
     * @method $this assertTableColumnSummarySet(string $columnName, string $summarizerId, $state, bool $isCurrentPaginationPageOnly = false)
     * @method $this assertTableColumnVisible(string $name)
     * @method $this assertTableEmptyStateActionsExistInOrder(array $names)
     * @method $this assertTableFilterExists(string $name, \Closure|null $checkFilterUsing = null)
     * @method $this assertTableFilterHidden(string $name)
     * @method $this assertTableFilterVisible(string $name)
     * @method $this assertTableHeaderActionsExistInOrder(array $names)
     * @method $this|void assertTableSelectColumnDoesNotHaveOptions(string $name, array $options, $record)
     * @method $this|void assertTableSelectColumnHasOptions(string $name, array $options, $record)
     * @method $this assertWizardCurrentStep(int $step, string $formName = 'form')
     * @method $this assertWizardStepExists(int $step, string $formName = 'form')
     * @method $this callFormComponentAction(array|string $component, array|string $name, array $data = [], array $arguments = [], string $formName = 'form')
     * @method $this callInfolistAction(string $component, array|string $name, array $data = [], array $arguments = [], string $infolistName = 'infolist')
     * @method $this callMountedFormComponentAction(array $arguments = [])
     * @method $this callMountedInfolistAction(array $arguments = [])
     * @method $this callMountedTableAction(array $arguments = [])
     * @method $this callMountedTableBulkAction(array $arguments = [])
     * @method $this callTableAction(array|string $name, $record = null, array $data = [], array $arguments = [])
     * @method $this callTableBulkAction(string $name, array|Collection $records, array $data = [], array $arguments = [])
     * @method $this callTableColumnAction(string $name, $record = null)
     * @method $this fillForm(array|\Closure $state = [], string $formName = 'form')
     * @method $this filterTable(string $name, $data = null)
     * @method array getNestedFormComponentActionComponentAndName(array|string $component, array|string $name, string $formName = 'form', array $arguments = [])
     * @method array getNestedInfolistActionComponentAndName(string $component, array|string $name, string $infolistName = 'infolist')
     * @method $this goToNextWizardStep(string $formName = 'form')
     * @method $this goToPreviousWizardStep(string $formName = 'form')
     * @method $this goToWizardStep(int $step, string $formName = 'form')
     * @method $this loadTable()
     * @method $this mountFormComponentAction(array|string $component, array|string $name, array $arguments = [], string $formName = 'form')
     * @method $this mountInfolistAction(string $component, array|string $name, string $infolistName = 'infolist')
     * @method $this mountTableAction(array|string $name, $record = null)
     * @method $this mountTableBulkAction(string $name, array|Collection $records)
     * @method array parseNestedFormComponentActionComponentAndName(array|string $component, array|string $name, string $formName = 'form')
     * @method $this removeTableFilter(string $filter, null|string $field = null)
     * @method $this removeTableFilters()
     * @method $this resetTableFilters()
     * @method $this searchTable(null|string $search = null)
     * @method $this searchTableColumns(array $searches)
     * @method $this setFormComponentActionData(array $data)
     * @method $this setInfolistActionData(array $data)
     * @method $this setTableActionData(array $data)
     * @method $this setTableBulkActionData(array $data)
     * @method $this sortTable(null|string $name = null, null|string $direction = null)
     * @method $this unmountFormComponentAction()
     * @method $this unmountInfolistAction()
     * @method $this unmountTableAction()
     */
    class Testable {}
}
