<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Ticket #<?php echo e($sale_order->number); ?></title>
    <style>
        * { font-size: 12px; font-family: 'Courier New', Courier, monospace; line-height: 1.2; }
        .ticket { width: 180px; max-width: 180px; margin: 0 auto; padding: 5px; }
        .centrado { text-align: center; }
        .derecha { text-align: right; }
        table { width: 100%; border-collapse: collapse; margin: 10px 0; }
        th { border-bottom: 1px dashed #000; text-align: left; }
        .linea { border-top: 1px dashed #000; margin: 5px 0; }
        .total-row td { padding-top: 4px; }
        @media print { .no-print { display: none; } body { margin: 0; } }
    </style>
</head>
<body onload="window.print()">
<div class="no-print" style="margin-bottom: 20px; text-align: center;">
    <button onclick="window.print()" style="padding: 10px;">IMPRIMIR TICKET</button>
</div>

<div class="ticket">
    <div class="centrado">
        <strong>GLOBAL GLAUCOMA</strong><br>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($sale_order->branch_id && $sale_order->branch): ?>
            <?php echo e($sale_order->branch->name); ?><br>
            <?php echo e($sale_order->branch->address ?? 'Dirección sucursal'); ?><br>
            <?php echo e($sale_order->branch->address2); ?><br>
            <?php echo e($sale_order->branch->city.', '. $sale_order->branch->state.', '. $sale_order->branch->zip); ?><br>
        <?php else: ?>
            Mariano Azueta #37<br>
            Ladrón de Guevara, GDL.<br>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        --------------------------------<br>
        Folio: <?php echo e($sale_order->number); ?><br>
        Fecha: <?php echo e($sale_order->created_at->format('d/m/Y H:i')); ?><br>
        Paciente: <?php echo e($sale_order->patient->name ?? 'Público General'); ?><br>
    </div>

    <table>
        <thead>
        <tr>
            <th>CANT</th>
            <th>DESC.</th>
            <th class="derecha">IMP.</th>
        </tr>
        </thead>
        <tbody>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $sale_order->lines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $line): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td colspan="3" style="padding-top: 5px;"><?php echo e($line->product_name); ?></td>
            </tr>
            <tr>
                <td><?php echo e($line->quantity); ?> x $<?php echo e(number_format($line->price, 2)); ?></td>
                <td><?php echo e($line->discount_percentage > 0 ? $line->discount_percentage.'%' : '-'); ?></td>
                <td class="derecha">$<?php echo e(number_format($line->amount, 2)); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </tbody>
    </table>

    <div class="linea"></div>

    <table class="total-row">
        <tr>
            <td>SUBTOTAL:</td>
            <td class="derecha">$<?php echo e(number_format($sale_order->subtotal + $sale_order->discount, 2)); ?></td>
        </tr>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($sale_order->discount > 0): ?>
            <tr>
                <td>DESCUENTO:</td>
                <td class="derecha">-$<?php echo e(number_format($sale_order->discount, 2)); ?></td>
            </tr>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        <tr>
            <td>IVA:</td>
            <td class="derecha">$<?php echo e(number_format($sale_order->tax, 2)); ?></td>
        </tr>
        <tr>
            <td><strong>TOTAL:</strong></td>
            <td class="derecha"><strong>$<?php echo e(number_format($sale_order->total, 2)); ?></strong></td>
        </tr>
        <tr>
            <td>SALDO:</td>
            <td class="derecha">$<?php echo e(number_format($sale_order->balance(), 2)); ?></td>
        </tr>
    </table>

    <div class="centrado" style="margin-top: 15px;">
        ¡GRACIAS POR SU PREFERENCIA!<br>
        --------------------------------
    </div>
</div>
</body>
</html><?php /**PATH /Users/jayanowsky/Projects/php/Global Glaucoma/globalglaucoma30/new-globalglaucoma/resources/views/livewire/documents/sale_order_ticket.blade.php ENDPATH**/ ?>