<div>
    <style>
        /* Estilos específicos para impresión */
        @media print {
            .no-print { display: none !important; }
            body { margin: 0; padding: 0; background: white; }
            .container { width: 100% !important; max-width: 100% !important; }
        }
        .page-header { border-bottom: 1px dotted #e2e2e2; padding-bottom: 1rem; }
        .bgc-default-tp1 { background-color: rgba(121,169,197,.92)!important; }
    </style>

    <!-- Carga de Bootstrap solo para este componente si no lo tienes global -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <div class="page-content container bg-white p-4 shadow-sm rounded">
        <div class="page-header text-blue-d2 d-flex justify-content-between align-items-center mb-4">
            <h1 class="page-title text-secondary">
                Reporte de cobranza
                <small class="text-muted d-block" style="font-size: 0.6em;">Usuario: <?php echo e(Auth::user()->name); ?></small>
            </h1>

            <div class="no-print d-flex gap-2">
                <div class="input-group input-group-sm">
                    <span class="input-group-text">Desde</span>
                    <input type="date" wire:model.live="startDate" class="form-control">
                </div>
                <div class="input-group input-group-sm">
                    <span class="input-group-text">Hasta</span>
                    <input type="date" wire:model.live="endDate" class="form-control">
                </div>
                <button onclick="window.print()" class="btn btn-primary btn-sm">
                    <i class="fa fa-print"></i> Imprimir
                </button>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-6">
                <span class="text-muted">Periodo:</span>
                <span class="fw-bold"><?php echo e(Carbon\Carbon::parse($startDate)->format('d/m/Y')); ?></span>
                al
                <span class="fw-bold"><?php echo e(Carbon\Carbon::parse($endDate)->format('d/m/Y')); ?></span>
            </div>
        </div>

        <div class="table-responsive mt-4">
            <table class="table table-striped table-borderless">
                <thead class="bgc-default-tp1 text-white">
                <tr>
                    <th>ID</th>
                    <th>NOTA DE VENTA</th>
                    <th>MÉTODO</th>
                    <th class="text-end">IMPORTE</th>
                </tr>
                </thead>
                <tbody>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($payment->id); ?></td>
                        <td><?php echo e($payment->saleOrder->number ?? 'N/A'); ?></td>
                        <td><?php echo e($payment->translateMethod()); ?></td>
                        <td class="text-end">$<?php echo e(number_format($payment->amount, 2)); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="4" class="text-center py-4">No hay pagos registrados en este periodo.</td>
                    </tr>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="row mt-4 justify-content-end">
            <div class="col-12 col-sm-4">
                <div class="d-flex justify-content-between p-2 border-bottom">
                    <span>Efectivo:</span>
                    <span class="fw-bold">$<?php echo e(number_format($total_cash, 2)); ?></span>
                </div>
                <div class="d-flex justify-content-between p-2 bg-light">
                    <span class="h5 mb-0">Total General:</span>
                    <span class="h5 mb-0 fw-bold text-primary">$<?php echo e(number_format($total, 2)); ?></span>
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH /Users/jayanowsky/Projects/php/Global Glaucoma/globalglaucoma30/new-globalglaucoma/resources/views/livewire/reports/payments/payments_report.blade.php ENDPATH**/ ?>