<div class="space-y-6">
    <!-- Tarjetas de Resumen (Sin cambios significativos) -->
    <div class="grid grid-cols-1 gap-5 sm:grid-cols-2 lg:grid-cols-4">
        <div class="overflow-hidden rounded-lg bg-white px-4 py-5 shadow sm:p-6">
            <dt class="truncate text-sm font-medium text-gray-500">Total Pacientes</dt>
            <dd class="mt-1 text-3xl font-semibold tracking-tight text-gray-900"><?php echo e($totalPatients); ?></dd>
        </div>
        <div class="overflow-hidden rounded-lg bg-white px-4 py-5 shadow sm:p-6">
            <dt class="truncate text-sm font-medium text-gray-500">Total Citas</dt>
            <dd class="mt-1 text-3xl font-semibold tracking-tight text-gray-900"><?php echo e($totalAppointments); ?></dd>
        </div>
        <div class="overflow-hidden rounded-lg bg-white px-4 py-5 shadow sm:p-6">
            <dt class="truncate text-sm font-medium text-gray-500">Cobrado Hoy (Mío)</dt>
            <dd class="mt-1 text-3xl font-semibold tracking-tight text-indigo-600">$<?php echo e(number_format($todayPaymentsSum, 2)); ?></dd>
        </div>
        <div class="overflow-hidden rounded-lg bg-white px-4 py-5 shadow sm:p-6">
            <dt class="truncate text-sm font-medium text-gray-500">Citas Sucursal (Hoy vs Ayer)</dt>
            <dd class="mt-1 flex items-baseline justify-between md:block lg:flex">
                <div class="flex items-baseline text-2xl font-semibold text-indigo-600">
                    <?php echo e($appointmentsTodayCount); ?>

                    <span class="ml-2 text-sm font-medium text-gray-500">vs <?php echo e($appointmentsYesterdayCount); ?></span>
                </div>
                <?php $diff = $appointmentsTodayCount - $appointmentsYesterdayCount; ?>
                <div class="inline-flex items-baseline rounded-full px-2.5 py-0.5 text-sm font-medium <?php echo e($diff >= 0 ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'); ?>">
                    <?php echo e($diff >= 0 ? '+' : ''); ?><?php echo e($diff); ?>

                </div>
            </dd>
        </div>
    </div>

    <div class="grid grid-cols-1 gap-6 lg:grid-cols-2">
        <!-- Listado de Citas de Hoy -->
        <div class="rounded-lg bg-white shadow flex flex-col">
            <div class="border-b border-gray-200 px-4 py-5 sm:px-6">
                <h3 class="text-base font-semibold leading-6 text-gray-900">Citas de Hoy (Sucursal)</h3>
            </div>
            <div class="px-4 py-5 sm:p-6 flex-1">
                <ul role="list" class="divide-y divide-gray-200">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $todayAppointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $app): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <li class="py-4 flex justify-between items-center">
                            <div class="min-w-0 flex-1">
                                <p class="text-sm font-medium text-gray-900 truncate"><?php echo e($app->patient->name); ?></p>
                                <p class="text-sm text-gray-500"><?php echo e(\Carbon\Carbon::parse($app->time)->format('H:i')); ?> - <?php echo e($app->type->name ?? 'Consulta'); ?></p>
                            </div>
                            <div>
                                <span class="inline-flex items-center rounded-full bg-blue-50 px-2 py-1 text-xs font-medium text-blue-700 ring-1 ring-inset ring-blue-700/10">
                                    <?php echo e($app->status); ?>

                                </span>
                            </div>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <p class="text-sm text-gray-500 py-4 text-center">No hay citas agendadas.</p>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </ul>
            </div>
            <div class="border-t border-gray-200 px-4 py-3 sm:px-6">
                <?php echo e($todayAppointments->links()); ?>

            </div>
        </div>

        <!-- Listado de Pagos Recibidos Hoy -->
        <div class="rounded-lg bg-white shadow flex flex-col">
            <div class="border-b border-gray-200 px-4 py-5 sm:px-6 flex items-center justify-between">
                <h3 class="text-base font-semibold leading-6 text-gray-900">Mis Pagos de Hoy</h3>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(\Illuminate\Support\Facades\Route::has('reports.payments')): ?>
                    <a href="<?php echo e(route('reports.payments', ['startDate' => date('Y-m-d'), 'endDate' => date('Y-m-d')])); ?>"
                       class="inline-flex items-center rounded-md bg-white px-2.5 py-1.5 text-sm font-semibold text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-50">
                        <?php if (isset($component)) { $__componentOriginal643fe1b47aec0b76658e1a0200b34b2c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c = $attributes; } ?>
<?php $component = BladeUI\Icons\Components\Svg::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('heroicon-o-document-text'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\BladeUI\Icons\Components\Svg::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => '-ml-0.5 mr-1.5 h-5 w-5 text-gray-400']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c)): ?>
<?php $attributes = $__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c; ?>
<?php unset($__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal643fe1b47aec0b76658e1a0200b34b2c)): ?>
<?php $component = $__componentOriginal643fe1b47aec0b76658e1a0200b34b2c; ?>
<?php unset($__componentOriginal643fe1b47aec0b76658e1a0200b34b2c); ?>
<?php endif; ?>
                        Ver Reporte
                    </a>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
            <div class="px-4 py-5 sm:p-6 flex-1">
                <ul role="list" class="divide-y divide-gray-200">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $todayPayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pay): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <li class="py-4 flex justify-between items-center">
                            <div class="min-w-0 flex-1">
                                <p class="text-sm font-medium text-gray-900 truncate">
                                    <?php echo e($pay->saleOrder->patient->name ?? 'Cliente General'); ?>

                                </p>
                                <p class="text-xs text-gray-500">Orden: <?php echo e($pay->saleOrder->number ?? '#'); ?> · <?php echo e($pay->translateMethod()); ?></p>
                            </div>
                            <div class="text-right">
                                <p class="text-sm font-bold text-gray-900">$<?php echo e(number_format($pay->amount, 2)); ?></p>
                                <p class="text-xs text-gray-400"><?php echo e($pay->created_at->format('H:i')); ?></p>
                            </div>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <p class="text-sm text-gray-500 py-4 text-center">Sin pagos registrados hoy.</p>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </ul>
            </div>
            <div class="border-t border-gray-200 px-4 py-3 sm:px-6">
                <?php echo e($todayPayments->links()); ?>

            </div>
        </div>
    </div>
</div><?php /**PATH /Users/jayanowsky/Projects/php/Global Glaucoma/globalglaucoma30/new-globalglaucoma/resources/views/livewire/dashboard.blade.php ENDPATH**/ ?>