<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Folio de Cita - <?php echo e($appointment->date->format('Y')); ?><?php echo e($appointment->id); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @media print {
            @page { size: letter; margin: 1cm; }
            .no-print { display: none; }
            body { background: white; }
        }
        .dotted-line { border-bottom: 1px dotted #000; height: 1.5rem; margin-bottom: 0.8rem; }
        .text-xxs { font-size: 0.65rem; }
    </style>
</head>
<body class="bg-gray-100 font-sans text-sm">
<div class="no-print p-4 bg-white border-b flex justify-between items-center shadow-sm">
    <span class="font-bold text-gray-700">Vista Previa: Folio <?php echo e($appointment->date->format('Y')); ?><?php echo e($appointment->id); ?></span>
    <div class="flex gap-2">
        <button onclick="window.close()" class="bg-gray-500 text-white px-4 py-1 rounded">Cerrar</button>
        <button onclick="window.print()" class="bg-blue-600 text-white px-4 py-1 rounded shadow">Imprimir Formato</button>
    </div>
</div>

<div class="bg-white p-10 mx-auto w-[21.59cm] min-h-[27.94cm] shadow-lg print:shadow-none print:p-0">
    <!-- Header -->
    <div class="flex justify-between items-start border-b-2 border-gray-800 pb-4 mb-6">
        <div>
            <h1 class="text-2xl font-black text-gray-900">FOLIO: <?php echo e($appointment->date->format('Y')); ?><?php echo e($appointment->id); ?></h1>
            <p class="text-gray-600">Fecha de Cita: <span class="font-bold text-black"><?php echo e($appointment->date->format('d/m/Y')); ?> - <?php echo e($appointment->time); ?></span></p>
        </div>
        <div class="text-right">
            <h2 class="text-lg font-bold text-indigo-800"><?php echo e($appointment->type->name); ?></h2>
            <p class="uppercase tracking-widest text-xs font-bold bg-gray-100 px-2 py-1 rounded mt-1 inline-block">
                <?php echo e($appointment->first_time ? 'Atención: Primera Vez' : 'Atención: Subsecuente'); ?>

            </p>
        </div>
    </div>

    <!-- Info Paciente -->
    <div class="mb-6 bg-gray-50 p-4 rounded-lg border border-gray-200">
        <p class="text-gray-700 uppercase text-xs font-bold mb-1">Nombre del Paciente</p>
        <p class="text-xl font-semibold"><?php echo e($appointment->patient->name); ?></p>
    </div>

    <!-- Cuerpo del Reporte -->
    <div class="grid grid-cols-3 gap-6 mb-8">
        <!-- Tabla Stages (Ocupa 2 columnas) -->
        <div class="col-span-2">
            <h3 class="font-bold text-gray-800 mb-2 uppercase text-xs tracking-wider">Cronometría de la Atención</h3>
            <table class="w-full border-collapse">
                <thead>
                <tr class="bg-gray-800 text-white text-xs">
                    <th class="p-2 text-left rounded-tl">Etapa / Observaciones</th>
                    <th class="p-2 text-center">Inicio</th>
                    <th class="p-2 text-center">Fin</th>
                    <th class="p-2 text-center">Min</th>
                    <th class="p-2 text-center rounded-tr">Atendió</th>
                </tr>
                </thead>
                <tbody class="text-xs">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $appointment->stages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                        <td class="p-2">
                            <div class="font-bold text-gray-900"><?php echo e($stage->concept_name); ?></div>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($stage->observations): ?>
                                <div class="text-xxs italic text-gray-500 leading-tight mt-1"><?php echo e($stage->observations); ?></div>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </td>
                        <td class="p-2 text-center font-mono"><?php echo e($stage->started_at?->format('H:i') ?: '--:--'); ?></td>
                        <td class="p-2 text-center font-mono"><?php echo e($stage->ended_at?->format('H:i') ?: '--:--'); ?></td>
                        <td class="p-2 text-center font-bold"><?php echo e($stage->duration_minutes); ?>'</td>
                        <td class="p-2 text-center uppercase font-bold text-gray-600">
                            <?php echo e(collect(explode(' ', $stage->user->name ?? ''))->map(fn($n) => substr($n, 0, 1))->join('')); ?>

                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </tbody>
                <tfoot class="bg-gray-50 font-bold">
                <tr>
                    <td colspan="3" class="p-2 text-right uppercase text-xxs">Tiempo Total de Atención:</td>
                    <td class="p-2 text-center text-sm"><?php echo e($appointment->total_duration_minutes); ?> min</td>
                    <td></td>
                </tr>
                </tfoot>
            </table>
        </div>

        <!-- Tabla Resumen Financiero -->
        <div class="col-span-1">
            <h3 class="font-bold text-gray-800 mb-2 uppercase text-xs tracking-wider">Detalle de Cobro</h3>
            <div class="border border-gray-300 rounded-lg overflow-hidden">
                <table class="w-full text-sm">
                    <tbody class="divide-y divide-gray-200">
                    <tr>
                        <td class="p-3 bg-gray-50 font-medium">Subtotal:</td>
                        <td class="p-3 text-right">$<?php echo e(number_format($appointment->saleOrder->subtotal ?? 0, 2)); ?></td>
                    </tr>
                    <tr>
                        <td class="p-3 bg-gray-50 font-medium text-red-600">Descuento (<?php echo e($appointment->discount_value); ?>%):</td>
                        <td class="p-3 text-right text-red-600">-$<?php echo e(number_format($appointment->saleOrder->discount ?? 0, 2)); ?></td>
                    </tr>
                    <tr class="bg-indigo-50">
                        <td class="p-3 font-black text-indigo-900">TOTAL:</td>
                        <td class="p-3 text-right font-black text-indigo-900 text-lg">$<?php echo e(number_format($appointment->saleOrder->total ?? 0, 2)); ?></td>
                    </tr>
                    </tbody>
                </table>
            </div>

            <div class="mt-4 space-y-2 text-xs">
                <div class="flex justify-between border-b border-gray-100 pb-1">
                    <span class="text-gray-500 font-bold uppercase">Ticket:</span>
                    <span class="font-mono"><?php echo e($appointment->saleOrder->number ?? '________________'); ?></span>
                </div>
                <div class="flex justify-between border-b border-gray-100 pb-1">
                    <span class="text-gray-500 font-bold uppercase">Factura:</span>
                    <span class="font-mono">________________</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Espacios para escribir (Receta y Notas) -->
    <div class="space-y-8">
        <div>
            <div class="flex items-center gap-2 mb-2">
                <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01"></path></svg>
                <h3 class="font-black text-gray-800 uppercase text-xs">Indicaciones Médicas / Receta</h3>
            </div>
            <div class="dotted-line"></div>
            <div class="dotted-line"></div>
            <div class="dotted-line"></div>
            <div class="dotted-line"></div>

        </div>

        <div>
            <div class="flex items-center gap-2 mb-2">
                <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path></svg>
                <h3 class="font-black text-gray-800 uppercase text-xs">Observaciones Adicionales</h3>
            </div>
            <div class="dotted-line"></div>
            <div class="dotted-line"></div>
            <div class="dotted-line"></div>
            
        </div>
    </div>


</div>
</body>
</html><?php /**PATH /Users/jayanowsky/Projects/php/Global Glaucoma/globalglaucoma30/new-globalglaucoma/resources/views/livewire/documents/appointment_document.blade.php ENDPATH**/ ?>