<?php

use App\Livewire\AppointmentsCrud;
use App\Livewire\AppointmentTracker;
use App\Livewire\Dashboard;
use App\Livewire\PatientsCrud;
use App\Livewire\Reports\Payments\PaymentsReport;
use App\Livewire\Reports\Sales\SalesReport;
use App\Livewire\SaleOrdersCrud;
use Illuminate\Support\Facades\Route;

Route::get('/', function(){
    return redirect()->route('pos');
});


Route::middleware('auth')->prefix('pos')->group(function () {
    Route::get('/dashboard', Dashboard::class)->name('pos'); // luego cambiamos Dashboard por tu componente POS real
    Route::get('/appointments', AppointmentsCrud::class)->name('pos.appointments');
    Route::get('/appointments/{appointment}/print', function (App\Models\Appointment $appointment) {
        return view('livewire.documents.appointment_document', [
            'appointment' => $appointment->load(['patient', 'type', 'stages.user', 'saleOrder'])
        ]);
    })->name('appointments.print');
    Route::get('/patients', PatientsCrud::class)->name('pos.patients');
    Route::get('/sale-orders', SaleOrdersCrud::class)->name('pos.sale-orders');
    Route::get('/tracker', AppointmentTracker::class)->name('appointments.tracker');
    Route::get('/sale-orders/{sale_order}/ticket', function (\App\Models\SaleOrder $sale_order) {
        return view('livewire.documents.sale_order_ticket', compact('sale_order'));
    })->name('sale-orders.ticket');

    //Reports

    Route::get('/reports/payments', PaymentsReport::class)
        ->name('reports.payments');

    Route::get('/reports/sales', SalesReport::class)->name('reports.sales');
});

require __DIR__.'/auth.php';
