<div>
<div class="space-y-6">
    <div class="flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between">
        <div>
            <h2 class="text-xl font-semibold text-gray-900">Órdenes de venta</h2>
            <p class="text-sm text-gray-600">
                Primero crea la orden (Paciente/Servidor/Primera visita), luego agrega conceptos.
            </p>
        </div>

        <button
            type="button"
            wire:click="resetToInitialCreate"
            class="inline-flex items-center justify-center rounded-md bg-white px-3 py-2 text-sm font-semibold text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-50"
        >
            Nueva orden
        </button>
    </div>

    <div class="grid grid-cols-1 gap-6 lg:grid-cols-3">
        <!-- Listado -->
        <div class="lg:col-span-2 space-y-3">
            <div class="grid grid-cols-1 gap-3 sm:grid-cols-2">
                <div>
                    <label class="block text-sm font-medium text-gray-700">Buscar</label>
                    <input
                        type="text"
                        wire:model.live="search"
                        placeholder="Folio o paciente..."
                        class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                    />
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700">Estatus pago</label>
                    <select
                        wire:model.live="paymentStatusFilter"
                        class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                    >
                        <option value="">Todos</option>
                        @foreach ($this->paymentStatusOptions as $st)
                            <option value="{{ $st }}">{{ $st }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="overflow-hidden rounded-lg bg-white shadow">
                <ul role="list" class="divide-y divide-gray-200">
                    @forelse ($orders as $o)
                        <li class="px-4 py-3 sm:px-6">
                            <div class="flex items-start justify-between gap-3">
                                <div class="min-w-0">
                                    <p class="truncate text-sm font-semibold text-gray-900">
                                        {{ $o->number ?: ('Orden #' . $o->id) }}
                                    </p>
                                    <p class="text-xs text-gray-600">
                                        {{ $o->date ?? 'Sin fecha' }}
                                        · {{ $o->patient->name ?? 'Sin paciente' }}
                                    </p>
                                    <div class="mt-1 flex flex-wrap items-center gap-2">

                                        <span class="inline-flex items-center rounded-full bg-gray-100 px-2 py-1 text-xs font-medium text-gray-700">
                                            Total: ${{ number_format((float) $o->total, 2) }}
                                        </span>

                                        @php $listBalance = $o->balance(); @endphp
                                        <span class="inline-flex items-center rounded-full {{ $listBalance > 0 ? 'bg-red-100 text-red-700' : 'bg-green-100 text-green-700' }} px-2 py-1 text-xs font-bold">
                                                Saldo: ${{ number_format($listBalance, 2) }}
                                        </span>

                                    </div>
                                </div>

                                <div class="flex items-center gap-2">
                                    <button
                                        type="button"
                                        wire:click="edit({{ $o->id }})"
                                        class="rounded-md bg-white px-3 py-2 text-sm font-semibold text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-50"
                                    >
                                        Abrir
                                    </button>
@if(1==2)
                                    <button
                                        type="button"
                                        wire:click="delete({{ $o->id }})"
                                        wire:confirm="¿Eliminar esta orden?"
                                        class="rounded-md bg-red-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-500"
                                    >
                                        Eliminar
                                    </button>
    @endif
                                </div>
                            </div>
                        </li>
                    @empty
                        <li class="px-4 py-10 text-center text-sm text-gray-600">
                            No hay órdenes.
                        </li>
                    @endforelse
                </ul>

                <div class="border-t border-gray-200 px-4 py-3 sm:px-6">
                    {{ $orders->links() }}
                </div>
            </div>
        </div>

        <!-- Panel derecho -->
        <div class="space-y-3">
            <div class="rounded-lg bg-white shadow">
                <div class="border-b border-gray-200 px-4 py-3 sm:px-6">
                    <h3 class="text-sm font-semibold text-gray-900">
                        {{ $editingId ? 'Orden (conceptos)' : 'Crear orden' }}
                    </h3>
                </div>

                <div class="px-4 py-4 sm:px-6 space-y-4">
                    @if (!$editingId)
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Paciente</label>
                            <div x-data="{ open: false }" class="relative mt-1">
                                <!-- Input que muestra el nombre seleccionado o permite buscar -->
                                <div class="flex">
                                    <input
                                        type="text"
                                        class="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm"
                                        placeholder="Buscar paciente..."
                                        wire:model.live.debounce.300ms="patientSearch"
                                        x-on:focus="open = true"
                                        x-on:click.away="open = false"
                                        value="{{ $selectedPatientName }}"
                                    />
                                    @if($patient_id && 1==2)
                                        <button type="button" wire:click="$set('patient_id', null); $set('selectedPatientName', '')" class="ml-2 text-gray-400 hover:text-gray-600">
                                            <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" /></svg>
                                        </button>
                                    @endif
                                </div>

                                @if($selectedPatientName)
                                    <p class="mt-1 text-xs text-indigo-600 font-medium">Seleccionado: {{ $selectedPatientName }}</p>
                                @endif

                                <!-- Lista de resultados -->
                                <div
                                    x-show="open && $wire.patientSearch.length > 0"
                                    class="absolute z-10 mt-1 max-h-60 w-full overflow-auto rounded-md bg-white py-1 text-base shadow-lg ring-1 ring-black ring-opacity-5 focus:outline-none sm:text-sm"
                                    style="display: none;"
                                >
                                    @forelse($patients as $p)
                                        <button
                                            type="button"
                                            wire:click="selectPatient({{ $p->id }}, '{{ addslashes($p->name) }}')"
                                            x-on:click="open = false"
                                            class="relative w-full cursor-default select-none py-2 pl-3 pr-9 text-left text-gray-900 hover:bg-indigo-600 hover:text-white"
                                        >
                                            {{ $p->name }}
                                        </button>
                                    @empty
                                        <div class="py-2 pl-3 text-gray-500 italic">No se encontraron resultados...</div>
                                    @endforelse
                                </div>
                            </div>
                            @error('patient_id') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700">Servidor</label>
                            <select
                                wire:model.defer="odoo_server"
                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                            >
                                <option value="">Seleccione...</option>
                                @foreach ($servers as $s)
                                    <option value="{{ $s->id }}">{{ $s->database }}</option>
                                @endforeach
                            </select>
                            @error('odoo_server') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                        </div>

                        <div class="flex items-center gap-2">
                            <input
                                id="first_time"
                                type="checkbox"
                                wire:model.defer="first_time"
                                class="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500"
                            />
                            <label for="first_time" class="text-sm text-gray-700">Primera visita</label>
                        </div>

                        <button
                            type="button"
                            wire:click="createEmptyOrder"
                            class="w-full inline-flex items-center justify-center rounded-md bg-indigo-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-indigo-500"
                        >
                            Crear orden y generar folio
                        </button>
                    @else
                        <div class="rounded-md bg-gray-50 p-3 text-sm text-gray-700">
                            <div class="flex justify-between"><span>Folio</span><span class="font-semibold">{{ $number }}</span></div>
                            <div class="flex justify-between"><span>Fecha</span><span class="font-semibold">{{ $date }}</span></div>
                            <div class="flex justify-between"><span>Servidor</span><span class="font-semibold">{{ $odoo_server }}</span></div>
                        </div>

                        <div class="rounded-md bg-gray-50 p-3 text-sm text-gray-700">
                            <div class="flex justify-between"><span>Subtotal</span><span class="font-semibold">${{ number_format($subtotal, 2) }}</span></div>
                            <div class="flex justify-between"><span>Descuento</span><span class="font-semibold">${{ number_format($discount, 2) }}</span></div>
                            <div class="flex justify-between"><span>Impuesto</span><span class="font-semibold">${{ number_format($tax, 2) }}</span></div>
                            <div class="mt-1 border-t border-gray-200 pt-2 flex justify-between text-gray-900">
                                <span class="font-semibold">Total</span>
                                <span class="font-bold">${{ number_format($total, 2) }}</span>
                            </div>

                            @if($editingId)

                                <div class="mt-1 flex justify-between text-sm {{ $balance > 0 ? 'text-red-600' : 'text-green-600' }}">
                                    <span>Saldo Pendiente</span>
                                    <span class="font-bold">${{ number_format($balance, 2) }}</span>
                                </div>

                                @if($balance > 0)
                                    <button
                                        type="button"
                                        wire:click="openPaymentModal"
                                        class="mt-3 w-full inline-flex items-center justify-center rounded-md bg-green-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-green-500 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-green-600"
                                    >
                                        Registrar Pago
                                    </button>
                                @endif

                                <button
                                    type="button"
                                    wire:click="printTicket({{ $editingId }})"
                                    class="mt-2 w-full inline-flex items-center justify-center rounded-md bg-white px-3 py-2 text-sm font-semibold text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-50"
                                >
                                    🖨️ Imprimir Ticket
                                </button>

                            @endif
                        </div>


                        <div class="space-y-2">
                            <div class="flex items-center justify-between">
                                <h4 class="text-sm font-semibold text-gray-900">Conceptos</h4>

                                @if($total == $balance)
                                <button
                                    type="button"
                                    wire:click="addLineAndOpenModal"
                                    class="rounded-md bg-white px-3 py-2 text-sm font-semibold text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-50"
                                >
                                    + Agregar
                                </button>
                                    @endif
                            </div>

                            <div class="overflow-hidden rounded-lg border border-gray-200 bg-white">
                                <div class="divide-y divide-gray-200">
                                    @forelse ($lines as $i => $line)
                                        <div class="p-3">
                                            <div class="flex items-start justify-between gap-3">
                                                <div class="min-w-0">
                                                    <div class="text-sm font-semibold text-gray-900 truncate">
                                                        {{ $line['product_name'] }}
                                                    </div>

                                                    <div class="mt-1 text-xs text-gray-600">
                                                        Cant: {{ $line['quantity'] ?? 1 }}
                                                        · Precio: ${{ number_format((float)($line['price'] ?? 0), 2) }}
                                                        · Desc: {{ (float)($line['discount_percentage'] ?? 0) }}%
                                                    </div>

                                                    <div class="mt-1 text-xs text-gray-700">
                                                        Importe: <span class="font-semibold">${{ number_format((float)($line['amount'] ?? 0), 2) }}</span>
                                                        · IVA: <span class="font-semibold">${{ number_format((float)($line['tax'] ?? 0), 2) }}</span>
                                                    </div>
                                                </div>

                                                @if($total == $balance)
                                                <div class="flex items-center gap-2 shrink-0">
                                                    <button
                                                        type="button"
                                                        wire:click="openLineModal({{ $i }})"
                                                        class="rounded-md bg-white px-3 py-2 text-sm font-semibold text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-50"
                                                    >
                                                        Editar
                                                    </button>

                                                    <button
                                                        type="button"
                                                        wire:click="removeLine({{ $i }})"
                                                        wire:confirm="¿Quitar este concepto?"
                                                        class="rounded-md bg-red-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-500"
                                                    >
                                                        Quitar
                                                    </button>
                                                </div>
                                                @endif
                                            </div>
                                        </div>
                                    @empty
                                        <div class="p-6 text-sm text-gray-500">
                                            Aún no hay conceptos.
                                        </div>
                                    @endforelse
                                </div>
                            </div>
                        </div>

                        <button
                            type="button"
                            wire:click="saveLines"
                            class="w-full inline-flex items-center justify-center rounded-md bg-indigo-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-indigo-500"
                        >
                            Guardar
                        </button>
                    @endif
                </div>
            </div>

        </div>
    </div>

    <div
        x-data="{ open: @entangle('showLineModal') }"
        x-show="open"
        x-on:keydown.escape.window="open = false"
        class="fixed inset-0 z-50 overflow-y-auto"
        style="display: none;"
    >
        <div class="flex min-h-screen items-end justify-center px-4 pt-4 pb-20 text-center sm:block sm:p-0">
            <!-- Fondo oscuro -->
            <div
                x-show="open"
                x-transition:enter="ease-out duration-300"
                x-transition:enter-start="opacity-0"
                x-transition:enter-end="opacity-100"
                x-transition:leave="ease-in duration-200"
                x-transition:leave-start="opacity-100"
                x-transition:leave-end="opacity-0"
                class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity"
                aria-hidden="true"
            ></div>

            <span class="hidden sm:inline-block sm:h-screen sm:align-middle" aria-hidden="true">&#8203;</span>

            <!-- Contenedor del Modal -->
            <div
                x-show="open"
                x-transition:enter="ease-out duration-300"
                x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
                x-transition:leave="ease-in duration-200"
                x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
                x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                class="relative inline-block transform overflow-hidden rounded-lg bg-white text-left align-bottom shadow-xl transition-all sm:my-8 sm:w-full sm:max-w-2xl sm:align-middle"
            >
                @if ($editingLineIndex !== null && isset($lines[$editingLineIndex]))
                    <div class="p-6 space-y-4">
                        <div class="flex items-start justify-between gap-3">
                            <div>
                                <h2 class="text-lg font-semibold text-gray-900">Agregar concepto</h2>
                                <p class="text-sm text-gray-600">Selecciona producto y ajusta cantidad / descuento (%).</p>
                            </div>
                            <button type="button" wire:click="closeLineModal" class="rounded-md bg-white px-3 py-2 text-sm font-semibold text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-50">
                                Cerrar
                            </button>
                        </div>

                        <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                            <div class="sm:col-span-2 space-y-2">
                                <label class="block text-sm font-medium text-gray-700">Buscar Producto</label>

                                <!-- Input de Búsqueda -->
                                <input
                                    type="text"
                                    wire:model.live.debounce.300ms="productSearch"
                                    placeholder="Escribe el nombre del producto..."
                                    class="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                                />

                                <!-- Lista de resultados (Buscador) -->
                                <div class="mt-1 max-h-40 overflow-y-auto border border-gray-200 rounded-md bg-white shadow-sm">
                                    @forelse($products as $prod)
                                        <button
                                            type="button"
                                            wire:click="selectProduct({{ $prod->id }})"
                                            class="w-full text-left px-3 py-2 text-sm hover:bg-indigo-50 {{ ($lines[$editingLineIndex]['product_id'] == $prod->id) ? 'bg-indigo-100 font-semibold' : '' }}"
                                        >
                                            {{ $prod->name }} - <span class="text-gray-500">${{ number_format($prod->list_price, 2) }}</span>
                                        </button>
                                    @empty
                                        <div class="px-3 py-2 text-sm text-gray-500">No se encontraron productos...</div>
                                    @endforelse
                                </div>
                                @error("lines.$editingLineIndex.product_id") <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700">Cantidad</label>
                                <input type="number" min="1" wire:model.live.blur="lines.{{ $editingLineIndex }}.quantity" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" />
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700">Descuento (%)</label>
                                <input type="number" min="0" max="100" step="0.01" wire:model.live="lines.{{ $editingLineIndex }}.discount_percentage" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" />
                            </div>
                        </div>

                        <div class="rounded-md bg-gray-50 p-4 text-sm text-gray-700">
                            <div class="font-medium text-indigo-700 mb-2 truncate">
                                {{ $lines[$editingLineIndex]['product_name'] ?? 'Ningún producto seleccionado' }}
                            </div>
                            <div class="flex justify-between"><span>Precio Unit.</span><span class="font-semibold">${{ number_format((float)($lines[$editingLineIndex]['price'] ?? 0), 2) }}</span></div>
                            <div class="flex justify-between"><span>Subtotal Línea</span><span class="font-semibold">${{ number_format((float)($lines[$editingLineIndex]['amount'] ?? 0), 2) }}</span></div>
                            <div class="flex justify-between text-xs text-gray-500"><span>IVA (estimado)</span><span>${{ number_format((float)($lines[$editingLineIndex]['tax'] ?? 0), 2) }}</span></div>
                        </div>

                        <div class="flex justify-end gap-2">
                            <button type="button" wire:click="closeLineModal" class="rounded-md bg-indigo-600 px-4 py-2 text-sm font-semibold text-white shadow-sm hover:bg-indigo-500">
                                Listo
                            </button>
                        </div>
                    </div>
                @endif
            </div>


        </div>
    </div>
    <div
        x-data="{ open: @entangle('showPaymentModal') }"
        x-show="open"
        class="fixed inset-0 z-50 overflow-y-auto"
        style="display: none;"
    >
        <div class="flex min-h-screen items-center justify-center p-4">
            <div x-show="open" class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity"></div>

            <div x-show="open" class="relative transform overflow-hidden rounded-lg bg-white text-left shadow-xl transition-all sm:w-full sm:max-w-lg">
                <div class="p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Registrar Pago / Anticipo</h3>

                    <div class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Tipo de movimiento</label>
                            <select wire:model.live="payment_type" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                @foreach($paymentTypeOptions as $opt)
                                    <option value="{{ $opt['value'] }}">{{ $opt['text'] }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700">Importe</label>
                            <div class="relative mt-1 rounded-md shadow-sm">
                                <div class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-3">
                                    <span class="text-gray-500 sm:text-sm">$</span>
                                </div>
                                <input type="number" step="0.01" wire:model.defer="payment_amount" class="block w-full rounded-md border-gray-300 pl-7 focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                            </div>
                            @error('payment_amount') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                        </div>

                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Método</label>
                                <select wire:model.defer="payment_method" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    @foreach($paymentMethodOptions as $opt)
                                        <option value="{{ $opt['value'] }}">{{ $opt['text'] }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Referencia</label>
                                <input type="text" wire:model.defer="payment_reference" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            </div>
                        </div>
                    </div>

                    <div class="mt-6 flex justify-end gap-3">
                        <button type="button" x-on:click="open = false" class="rounded-md bg-white px-3 py-2 text-sm font-semibold text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-50">
                            Cancelar
                        </button>
                        <button type="button" wire:click="savePayment" class="rounded-md bg-indigo-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-indigo-500">
                            Confirmar Pago
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

</div>
