<div>
    <style>
        @media print {
            .no-print { display: none !important; }
            body { background: white; }
            .container { width: 100% !important; max-width: 100% !important; }
        }
        .bgc-default-tp1 { background-color: rgba(121,169,197,.92)!important; }
        .table th { font-size: 0.85rem; text-transform: uppercase; }
        .table td { font-size: 0.85rem; vertical-align: middle; }
    </style>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <div class="page-content container bg-white p-4 shadow-sm rounded">
        <!-- Header / Filtros -->
        <div class="page-header border-bottom pb-3 mb-4">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h1 class="h3 text-secondary mb-0">Reportes de Ventas</h1>
                <div class="no-print">
                    <button onclick="window.print()" class="btn btn-outline-secondary btn-sm">
                        <i class="fa fa-print"></i> Imprimir
                    </button>
                    <button wire:click="exportToExcel" class="btn btn-success btn-sm">
                        <i class="fa fa-file-excel"></i> Exportar Excel
                    </button>
                </div>
            </div>

            <div class="row g-3 no-print align-items-end">
                <div class="col-md-4">
                    <label class="form-label small fw-bold">Tipo de Reporte</label>
                    <select wire:model.live="reportType" class="form-select form-select-sm">
                        <option value="daily_concept">1. Ventas Diarias por concepto</option>
                        <option value="user_detailed">2. Ventas detalladas por usuario</option>
                        <option value="daily_sal">3. Ventas diarias concepto + SAL</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label small fw-bold">Desde</label>
                    <input type="date" wire:model.live="fromDate" class="form-control form-control-sm">
                </div>
                <div class="col-md-3">
                    <label class="form-label small fw-bold">Hasta</label>
                    <input type="date" wire:model.live="toDate" class="form-control form-control-sm">
                </div>
@if($reportType === 'user_detailed')
                <div class="col-md-3">
                    <label class="form-label small fw-bold">Usuario @if($reportType === 'user_detailed') <span class="text-danger">*</span> @endif</label>
                    <select wire:model.live="userId" class="form-select form-select-sm @error('userId') is-invalid @enderror">
                        <option value="">Seleccione usuario...</option>
                        @foreach($usersList as $user)
                            <option value="{{ $user['id'] }}">{{ $user['name'] }}</option>
                        @endforeach
                    </select>
                    @error('userId') <div class="invalid-feedback" style="font-size: 0.7rem;">Requerido</div> @enderror
                </div>
@endif
                <div class="col-md-2">
                    <button wire:click="generateReport" wire:loading.attr="disabled" class="btn btn-primary btn-sm w-100">
                        <span wire:loading.remove>Consultar</span>
                        <span wire:loading>...</span>
                    </button>
                </div>
            </div>
        </div>

        <!-- Resultados -->
        <div class="table-responsive">
            @if(empty($results))
                <div class="text-center py-5 text-muted">
                    Seleccione los parámetros y haga clic en Consultar.
                </div>
            @else
                <table class="table table-striped table-hover border">
                    <thead class="bgc-default-tp1 text-white">
                    @if($reportType == 'daily_concept')
                        <tr>
                            <th>Producto</th>
                            <th class="text-center">Cantidad</th>
                            <th class="text-end">Precio</th>
                            <th class="text-end">Descuento</th>
                            <th class="text-end">Importe</th>
                        </tr>
                    @elseif($reportType == 'user_detailed')
                        <tr>
                            <th>Fecha</th>
                            <th>Paciente</th>
                            <th class="text-center">1ra Vez</th>
                            <th>Concepto</th>
                            <th class="text-center">Cant.</th>
                            <th class="text-end">Precio</th>
                            <th class="text-end">Desc.</th>
                            <th class="text-end">Subtotal</th>
                            <th class="text-end">IVA</th>
                            <th class="text-end">Total</th>
                        </tr>
                    @elseif($reportType == 'daily_sal')
                        <tr>
                            <th>Producto</th>
                            <th class="text-center">Cant.</th>
                            <th class="text-end">Precio</th>
                            <th class="text-end">IVA</th>
                            <th class="text-end">Importe</th>
                            <th class="text-center">Fecha</th>
                            <th class="text-end">Abono</th>
                            <th class="text-end text-danger">Saldo</th>
                        </tr>
                    @endif
                    </thead>
                    <tbody>
                    @foreach($results as $item)
                        <tr>
                            @if($reportType == 'daily_concept')
                                <td>{{ $item['product_name'] }}</td>
                                <td class="text-center">{{ $item['quantity'] }}</td>
                                <td class="text-end">${{ number_format($item['price'], 2) }}</td>
                                <td class="text-end">${{ number_format($item['discount'], 2) }}</td>
                                <td class="text-end fw-bold">${{ number_format($item['amount'], 2) }}</td>

                            @elseif($reportType == 'user_detailed')
                                <td>{{ $item['date'] }}</td>
                                <td>{{ $item['patient'] }}</td>
                                <td class="text-center small">{{ $item['first_time'] }}</td>
                                <td>{{ $item['product_name'] }}</td>
                                <td class="text-center">{{ $item['quantity'] }}</td>
                                <td class="text-end">${{ number_format($item['price'], 2) }}</td>
                                <td class="text-end">${{ number_format($item['discount'], 2) }}</td>
                                <td class="text-end">${{ number_format($item['amount'], 2) }}</td>
                                <td class="text-end">${{ number_format($item['tax'], 2) }}</td>
                                <td class="text-end fw-bold">${{ number_format($item['total'], 2) }}</td>

                            @elseif($reportType == 'daily_sal')
                                <td>{{ $item['product_name'] }}</td>
                                <td class="text-center">{{ $item['quantity'] }}</td>
                                <td class="text-end">${{ number_format($item['price'], 2) }}</td>
                                <td class="text-end">${{ number_format($item['tax'], 2) }}</td>
                                <td class="text-end">${{ number_format($item['amount'], 2) }}</td>
                                <td class="text-center">{{ $item['date'] }}</td>
                                <td class="text-end text-success">${{ number_format($item['paid'], 2) }}</td>
                                <td class="text-end fw-bold text-danger">${{ number_format($item['balance'], 2) }}</td>
                            @endif
                        </tr>
                    @endforeach
                    </tbody>
                </table>

                <!-- Paginación -->
                <div class="mt-3 no-print d-flex justify-content-center">
                    @if($results instanceof \Illuminate\Pagination\LengthAwarePaginator)
                        {{ $results->links() }}
                    @endif
                </div>

            @endif
        </div>
    </div>
</div>
