<div>
    <div class="space-y-6">
        <div class="flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between">
            <div>
                <h2 class="text-xl font-semibold text-gray-900">Pacientes</h2>
                <p class="text-sm text-gray-600">Crear, editar y administrar pacientes.</p>
            </div>

            <button
                type="button"
                wire:click="create"
                class="inline-flex items-center justify-center rounded-md bg-indigo-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-indigo-500"
            >
                Nuevo paciente
            </button>
        </div>

        <div class="grid grid-cols-1 gap-6 lg:grid-cols-3">
            <div class="lg:col-span-2 space-y-3">
                <div>
                    <label class="block text-sm font-medium text-gray-700">Buscar</label>
                    <input
                        type="text"
                        wire:model.live="search"
                        placeholder="Nombre, email, teléfono o RFC..."
                        class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                    />
                </div>

                <div class="overflow-hidden rounded-lg bg-white shadow">
                    <ul role="list" class="divide-y divide-gray-200">
                        @forelse ($patients as $p)
                            <li class="px-4 py-3 sm:px-6">
                                <div class="flex items-start justify-between gap-3">
                                    <div class="min-w-0">
                                        <p class="truncate text-sm font-semibold text-gray-900">
                                            {{ $p->name ?: ('Paciente #' . $p->id) }}
                                        </p>

                                        <p class="text-xs text-gray-600">
                                            {{ $p->email ?: 'Sin email' }}
                                            @if ($p->mobile)
                                                · {{ $p->mobile }}
                                            @elseif ($p->phone)
                                                · {{ $p->phone }}
                                            @endif
                                        </p>

                                        <div class="mt-1 flex flex-wrap items-center gap-2">
                                        <span class="inline-flex items-center rounded-full bg-gray-100 px-2 py-1 text-xs font-medium text-gray-700">
                                            {{ $p->gender }}
                                        </span>

                                            <span class="inline-flex items-center rounded-full bg-gray-100 px-2 py-1 text-xs font-medium text-gray-700">
                                            RFC: {{ $p->tin }}
                                        </span>
                                        </div>
                                    </div>

                                    <div class="flex items-center gap-2">
                                        <button
                                            type="button"
                                            wire:click="edit({{ $p->id }})"
                                            class="rounded-md bg-white px-3 py-2 text-sm font-semibold text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-50"
                                        >
                                            Editar
                                        </button>

                                        <button
                                            type="button"
                                            wire:click="delete({{ $p->id }})"
                                            wire:confirm="¿Eliminar este paciente?"
                                            class="rounded-md bg-red-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-500"
                                        >
                                            Eliminar
                                        </button>
                                    </div>
                                </div>
                            </li>
                        @empty
                            <li class="px-4 py-10 text-center text-sm text-gray-600">
                                No hay pacientes.
                            </li>
                        @endforelse
                    </ul>

                    <div class="border-t border-gray-200 px-4 py-3 sm:px-6">
                        {{ $patients->links() }}
                    </div>
                </div>
            </div>

            <div class="space-y-3">
                <div class="rounded-lg bg-white shadow">
                    <div class="border-b border-gray-200 px-4 py-3 sm:px-6">
                        <h3 class="text-sm font-semibold text-gray-900">
                            {{ $editingId ? 'Editar paciente' : 'Crear paciente' }}
                        </h3>
                    </div>

                    <div class="px-4 py-4 sm:px-6 space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Nombre</label>
                            <input type="text" wire:model.defer="name" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" />
                            @error('name') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                        </div>

                        <div class="grid grid-cols-1 gap-3 sm:grid-cols-2">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Nacimiento</label>
                                <input type="date" wire:model.defer="birthday" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" />
                                @error('birthday') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700">Género</label>
                                <select wire:model.defer="gender" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    @foreach ($genderOptions as $g)
                                        <option value="{{ $g }}">{{ $g }}</option>
                                    @endforeach
                                </select>
                                @error('gender') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                            </div>
                        </div>

                        <div class="grid grid-cols-1 gap-3 sm:grid-cols-2">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Teléfono</label>
                                <input type="text" wire:model.defer="phone" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" />
                                @error('phone') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700">Celular</label>
                                <input type="text" wire:model.defer="mobile" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" />
                                @error('mobile') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                            </div>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700">Email</label>
                            <input type="email" wire:model.defer="email" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" />
                            @error('email') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                        </div>


                            <div>
                                <label class="block text-sm font-medium text-gray-700">Razon Social</label>
                                <input type="text" wire:model.defer="company_name" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" />
                                @error('company_name') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700">RFC</label>
                                <input type="text" wire:model.defer="tin" maxlength="13" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" />
                                @error('tin') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                            </div>



                            <div>
                                <label class="block text-sm font-medium text-gray-700">Direccion</label>
                                <input type="text" wire:model.defer="street" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" />
                                @error('street') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700">Colonia</label>
                                <input type="text" wire:model.defer="street2" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" />
                                @error('street2') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                            </div>


                        <div class="grid grid-cols-1 gap-3 sm:grid-cols-2">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Ciudad</label>
                                <input type="text" wire:model.defer="city" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" />
                                @error('city') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700">Estado</label>
                                <input type="text" wire:model.defer="state" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" />
                                @error('state') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                            </div>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">País</label>
                            <input type="text" wire:model.defer="country" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" />
                            @error('country') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                        </div>


                        <div class="flex items-center gap-2">
                            <button
                                type="button"
                                wire:click="save"
                                class="inline-flex items-center justify-center rounded-md bg-indigo-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-indigo-500"
                            >
                                Guardar
                            </button>

                            <button
                                type="button"
                                wire:click="create"
                                class="inline-flex items-center justify-center rounded-md bg-white px-3 py-2 text-sm font-semibold text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-50"
                            >
                                Limpiar
                            </button>
                        </div>
                    </div>
                </div>


            </div>
        </div>
    </div>
</div>
