<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Ticket #{{ $sale_order->number }}</title>
    <style>
        * { font-size: 12px; font-family: 'Courier New', Courier, monospace; line-height: 1.2; }
        .ticket { width: 180px; max-width: 180px; margin: 0 auto; padding: 5px; }
        .centrado { text-align: center; }
        .derecha { text-align: right; }
        table { width: 100%; border-collapse: collapse; margin: 10px 0; }
        th { border-bottom: 1px dashed #000; text-align: left; }
        .linea { border-top: 1px dashed #000; margin: 5px 0; }
        .total-row td { padding-top: 4px; }
        @media print { .no-print { display: none; } body { margin: 0; } }
    </style>
</head>
<body onload="window.print()">
<div class="no-print" style="margin-bottom: 20px; text-align: center;">
    <button onclick="window.print()" style="padding: 10px;">IMPRIMIR TICKET</button>
</div>

<div class="ticket">
    <div class="centrado">
        <strong>GLOBAL GLAUCOMA</strong><br>
        @if($sale_order->branch_id && $sale_order->branch)
            {{ $sale_order->branch->name }}<br>
            {{ $sale_order->branch->address ?? 'Dirección sucursal' }}<br>
            {{ $sale_order->branch->address2  }}<br>
            {{ $sale_order->branch->city.', '. $sale_order->branch->state.', '. $sale_order->branch->zip }}<br>
        @else
            Mariano Azueta #37<br>
            Ladrón de Guevara, GDL.<br>
        @endif
        --------------------------------<br>
        Folio: {{ $sale_order->number }}<br>
        Fecha: {{ $sale_order->created_at->format('d/m/Y H:i') }}<br>
        Paciente: {{ $sale_order->patient->name ?? 'Público General' }}<br>
    </div>

    <table>
        <thead>
        <tr>
            <th>CANT</th>
            <th>DESC.</th>
            <th class="derecha">IMP.</th>
        </tr>
        </thead>
        <tbody>
        @foreach($sale_order->lines as $line)
            <tr>
                <td colspan="3" style="padding-top: 5px;">{{ $line->product_name }}</td>
            </tr>
            <tr>
                <td>{{ $line->quantity }} x ${{ number_format($line->price, 2) }}</td>
                <td>{{ $line->discount_percentage > 0 ? $line->discount_percentage.'%' : '-' }}</td>
                <td class="derecha">${{ number_format($line->amount, 2) }}</td>
            </tr>
        @endforeach
        </tbody>
    </table>

    <div class="linea"></div>

    <table class="total-row">
        <tr>
            <td>SUBTOTAL:</td>
            <td class="derecha">${{ number_format($sale_order->subtotal + $sale_order->discount, 2) }}</td>
        </tr>
        @if($sale_order->discount > 0)
            <tr>
                <td>DESCUENTO:</td>
                <td class="derecha">-${{ number_format($sale_order->discount, 2) }}</td>
            </tr>
        @endif
        <tr>
            <td>IVA:</td>
            <td class="derecha">${{ number_format($sale_order->tax, 2) }}</td>
        </tr>
        <tr>
            <td><strong>TOTAL:</strong></td>
            <td class="derecha"><strong>${{ number_format($sale_order->total, 2) }}</strong></td>
        </tr>
        <tr>
            <td>SALDO:</td>
            <td class="derecha">${{ number_format($sale_order->balance(), 2) }}</td>
        </tr>
    </table>

    <div class="centrado" style="margin-top: 15px;">
        ¡GRACIAS POR SU PREFERENCIA!<br>
        --------------------------------
    </div>
</div>
</body>
</html>
