<div class="space-y-6">
    <!-- Tarjetas de Resumen (Sin cambios significativos) -->
    <div class="grid grid-cols-1 gap-5 sm:grid-cols-2 lg:grid-cols-4">
        <div class="overflow-hidden rounded-lg bg-white px-4 py-5 shadow sm:p-6">
            <dt class="truncate text-sm font-medium text-gray-500">Total Pacientes</dt>
            <dd class="mt-1 text-3xl font-semibold tracking-tight text-gray-900">{{ $totalPatients }}</dd>
        </div>
        <div class="overflow-hidden rounded-lg bg-white px-4 py-5 shadow sm:p-6">
            <dt class="truncate text-sm font-medium text-gray-500">Total Citas</dt>
            <dd class="mt-1 text-3xl font-semibold tracking-tight text-gray-900">{{ $totalAppointments }}</dd>
        </div>
        <div class="overflow-hidden rounded-lg bg-white px-4 py-5 shadow sm:p-6">
            <dt class="truncate text-sm font-medium text-gray-500">Cobrado Hoy (Mío)</dt>
            <dd class="mt-1 text-3xl font-semibold tracking-tight text-indigo-600">${{ number_format($todayPaymentsSum, 2) }}</dd>
        </div>
        <div class="overflow-hidden rounded-lg bg-white px-4 py-5 shadow sm:p-6">
            <dt class="truncate text-sm font-medium text-gray-500">Citas Sucursal (Hoy vs Ayer)</dt>
            <dd class="mt-1 flex items-baseline justify-between md:block lg:flex">
                <div class="flex items-baseline text-2xl font-semibold text-indigo-600">
                    {{ $appointmentsTodayCount }}
                    <span class="ml-2 text-sm font-medium text-gray-500">vs {{ $appointmentsYesterdayCount }}</span>
                </div>
                @php $diff = $appointmentsTodayCount - $appointmentsYesterdayCount; @endphp
                <div class="inline-flex items-baseline rounded-full px-2.5 py-0.5 text-sm font-medium {{ $diff >= 0 ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                    {{ $diff >= 0 ? '+' : '' }}{{ $diff }}
                </div>
            </dd>
        </div>
    </div>

    <div class="grid grid-cols-1 gap-6 lg:grid-cols-2">
        <!-- Listado de Citas de Hoy -->
        <div class="rounded-lg bg-white shadow flex flex-col">
            <div class="border-b border-gray-200 px-4 py-5 sm:px-6">
                <h3 class="text-base font-semibold leading-6 text-gray-900">Citas de Hoy (Sucursal)</h3>
            </div>
            <div class="px-4 py-5 sm:p-6 flex-1">
                <ul role="list" class="divide-y divide-gray-200">
                    @forelse($todayAppointments as $app)
                        <li class="py-4 flex justify-between items-center">
                            <div class="min-w-0 flex-1">
                                <p class="text-sm font-medium text-gray-900 truncate">{{ $app->patient->name }}</p>
                                <p class="text-sm text-gray-500">{{ \Carbon\Carbon::parse($app->time)->format('H:i') }} - {{ $app->type->name ?? 'Consulta' }}</p>
                            </div>
                            <div>
                                <span class="inline-flex items-center rounded-full bg-blue-50 px-2 py-1 text-xs font-medium text-blue-700 ring-1 ring-inset ring-blue-700/10">
                                    {{ $app->status }}
                                </span>
                            </div>
                        </li>
                    @empty
                        <p class="text-sm text-gray-500 py-4 text-center">No hay citas agendadas.</p>
                    @endforelse
                </ul>
            </div>
            <div class="border-t border-gray-200 px-4 py-3 sm:px-6">
                {{ $todayAppointments->links() }}
            </div>
        </div>

        <!-- Listado de Pagos Recibidos Hoy -->
        <div class="rounded-lg bg-white shadow flex flex-col">
            <div class="border-b border-gray-200 px-4 py-5 sm:px-6 flex items-center justify-between">
                <h3 class="text-base font-semibold leading-6 text-gray-900">Mis Pagos de Hoy</h3>
                @if(\Illuminate\Support\Facades\Route::has('reports.payments'))
                    <a href="{{ route('reports.payments', ['startDate' => date('Y-m-d'), 'endDate' => date('Y-m-d')]) }}"
                       class="inline-flex items-center rounded-md bg-white px-2.5 py-1.5 text-sm font-semibold text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-50">
                        <x-heroicon-o-document-text class="-ml-0.5 mr-1.5 h-5 w-5 text-gray-400" />
                        Ver Reporte
                    </a>
                @endif
            </div>
            <div class="px-4 py-5 sm:p-6 flex-1">
                <ul role="list" class="divide-y divide-gray-200">
                    @forelse($todayPayments as $pay)
                        <li class="py-4 flex justify-between items-center">
                            <div class="min-w-0 flex-1">
                                <p class="text-sm font-medium text-gray-900 truncate">
                                    {{ $pay->saleOrder->patient->name ?? 'Cliente General' }}
                                </p>
                                <p class="text-xs text-gray-500">Orden: {{ $pay->saleOrder->number ?? '#' }} · {{ $pay->translateMethod() }}</p>
                            </div>
                            <div class="text-right">
                                <p class="text-sm font-bold text-gray-900">${{ number_format($pay->amount, 2) }}</p>
                                <p class="text-xs text-gray-400">{{ $pay->created_at->format('H:i') }}</p>
                            </div>
                        </li>
                    @empty
                        <p class="text-sm text-gray-500 py-4 text-center">Sin pagos registrados hoy.</p>
                    @endforelse
                </ul>
            </div>
            <div class="border-t border-gray-200 px-4 py-3 sm:px-6">
                {{ $todayPayments->links() }}
            </div>
        </div>

        <!-- Follow Up -->

        <div class="bg-white rounded-lg shadow">
            <div class="p-4 border-b font-bold text-gray-700 flex justify-between">
                <span>Seguimientos Pendientes (To-Do)</span>
                <span class="bg-red-100 text-red-700 px-2 py-1 rounded-full text-xs">{{ $pendingFollowUps->count() }}</span>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full text-sm text-left">
                    <thead class="bg-gray-50 text-gray-500 uppercase text-xs">
                    <tr>
                        <th class="px-4 py-3">Vence</th>
                        <th class="px-4 py-3">Paciente</th>
                        <th class="px-4 py-3">Motivo</th>
                        <th class="px-4 py-3">Origen</th>
                        <th class="px-4 py-3 text-right">Acción</th>
                    </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                    @forelse($pendingFollowUps as $f)
                        <tr class="{{ $f->due_date->isPast() ? 'bg-red-50' : '' }}">
                            <td class="px-4 py-3 font-medium {{ $f->due_date->isPast() ? 'text-red-700' : '' }}">
                                {{ $f->due_date->format('d/m/Y') }}
                            </td>
                            <td class="px-4 py-3">{{ $f->patient->name }}</td>
                            <td class="px-4 py-3">{{ $f->reason }}</td>
                            <td class="px-4 py-3 text-xs text-gray-500">Cita #{{ $f->appointment_id }}</td>
                            <td class="px-4 py-3 text-right">
                                <button wire:click="openCloseModal({{ $f->id }})" class="bg-green-600 text-white px-3 py-1 rounded hover:bg-green-700">Completar</button>
                            </td>
                        </tr>
                    @empty
                        <tr><td colspan="5" class="p-4 text-center text-gray-500 italic">No hay seguimientos pendientes.</td></tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Modal para Follow Up -->
        @if($showCloseModal)
            <div class="fixed inset-0 z-50 flex items-center justify-center bg-black bg-opacity-50">
                <div class="bg-white rounded-lg p-6 w-full max-w-md shadow-xl">
                    <h3 class="text-lg font-bold mb-4 uppercase">Cerrar Seguimiento</h3>
                    <div class="space-y-4">
                        <p class="text-sm text-gray-600">Por favor, indica las observaciones finales para marcar esta tarea como completada.</p>
                        <textarea wire:model="closingObservations" class="w-full border-gray-300 rounded-md h-32" placeholder="Resultado del contacto con el paciente o notas finales..."></textarea>
                    </div>
                    <div class="mt-6 flex justify-end gap-2">
                        <button wire:click="$set('showCloseModal', false)" class="px-4 py-2 text-gray-500">Cancelar</button>
                        <button wire:click="closeFollowUp" class="bg-blue-600 text-white px-4 py-2 rounded shadow hover:bg-blue-700">Finalizar Seguimiento</button>
                    </div>
                </div>
            </div>
        @endif


    </div>
</div>
