<div>


    <div class="space-y-6">
        <div class="flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between">
            <div>
                <h2 class="text-xl font-semibold text-gray-900">Citas</h2>
                <p class="text-sm text-gray-600">Crear, editar y administrar citas.</p>
            </div>

            <button
                type="button"
                wire:click="create"
                class="inline-flex items-center justify-center rounded-md bg-indigo-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-indigo-500"
            >
                Nueva cita
            </button>
        </div>

        <div class="grid grid-cols-1 gap-6 lg:grid-cols-3">
            <div class="lg:col-span-2 space-y-3">
                <div class="grid grid-cols-1 gap-3 sm:grid-cols-3">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Buscar paciente</label>
                        <input
                            type="text"
                            wire:model.live="search"
                            placeholder="Nombre del paciente..."
                            class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                        />
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700">Estado</label>
                        <select
                            wire:model.live="statusFilter"
                            class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                        >
                            <option value="">Todos</option>
                            @foreach ($this->statusOptions as $st)
                                <option value="{{ $st }}">{{ $st }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700">Fecha</label>
                        <input
                            type="date"
                            wire:model.live="dateFilter"
                            class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                        />
                    </div>
                </div>

                <div class="overflow-hidden rounded-lg bg-white shadow">
                    <ul role="list" class="divide-y divide-gray-200">
                        @forelse ($appointments as $a)
                            <li class="px-4 py-3 sm:px-6">
                                <div class="flex items-start justify-between gap-3">
                                    <div class="min-w-0">
                                        <div class="flex items-center gap-2">
                                            <p class="truncate text-sm font-semibold text-gray-900">
                                                {{ $a->patient->name ?? ('Paciente #' . $a->patient_id) }}
                                            </p>
                                            @if ($a->first_time)
                                                <span class="inline-flex items-center rounded-md bg-amber-50 px-2 py-1 text-xs font-medium text-amber-700 ring-1 ring-inset ring-amber-600/20">
                                                        Primera visita
                                                    </span>
                                            @endif
                                        </div>
                                        <p class="text-xs text-gray-600">
                                            {{ $a->date }} {{ \Illuminate\Support\Str::of($a->time)->substr(0, 5) }}
                                            · {{ $a->type->name ?? 'Sin tipo' }}
                                        </p>
                                        <p class="mt-1 inline-flex items-center rounded-full bg-gray-100 px-2 py-1 text-xs font-medium text-gray-700">
                                            {{ $a->status }}
                                        </p>
                                    </div>

                                    <div class="flex items-center gap-2">

                                        @if($a->status === 'Finalizada' && !$a->sale_order_id)
                                            <button wire:click="CreateSaleOrderFromAppointment({{ $a->id }})"
                                                    class="text-green-600 hover:text-green-900 bg-green-50 px-6 py-5 rounded border border-green-200"
                                                    title="Generar Ticket">
                                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5l5 5v11a2 2 0 01-2 2z"></path></svg>

                                            </button>
                                        @elseif($a->sale_order_id)
                                            <span class="text-gray-400 px-2 py-1 text-xs italic bg-gray-50 rounded border border-gray-200">
                                        Ticket #{{ $a->saleOrder->number }}
                                    </span>
                                        @endif

                                            @if($a->status === 'Finalizada')
                                                <a href="{{ route('appointments.print', $a->id) }}"
                                                   target="_blank"
                                                   class="text-blue-600 hover:text-blue-900 bg-blue-50 px-2 py-1 rounded border border-blue-200"
                                                   title="Imprimir Folio">
                                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"></path></svg>
                                                </a>
                                            @endif

                                            @if($a->status === 'Creada' && !$a->sale_order_id)
                                        <button
                                            type="button"
                                            wire:click="edit({{ $a->id }})"
                                            class="rounded-md bg-white px-3 py-2 text-sm font-semibold text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-50"
                                        >
                                            Editar
                                        </button>
                                            @endif
@if(1==2)
                                        <button
                                            type="button"
                                            wire:click="delete({{ $a->id }})"
                                            wire:confirm="¿Eliminar esta cita?"
                                            class="rounded-md bg-red-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-500"
                                        >
                                            Eliminar
                                        </button>
    @endif
                                    </div>
                                </div>

                                @if ($a->note)
                                    <p class="mt-2 text-sm text-gray-600">
                                        <span class="font-medium">Nota:</span> {{ $a->note }}
                                    </p>
                                @endif
                            </li>


                        @empty
                            <li class="px-4 py-10 text-center text-sm text-gray-600">
                                No hay citas.
                            </li>
                        @endforelse
                    </ul>

                    <div class="border-t border-gray-200 px-4 py-3 sm:px-6">
                        {{ $appointments->links() }}
                    </div>
                </div>
            </div>

            <div class="space-y-3">
                <div class="rounded-lg bg-white shadow">
                    <div class="border-b border-gray-200 px-4 py-3 sm:px-6">
                        <h3 class="text-sm font-semibold text-gray-900">
                            {{ $editingId ? 'Editar cita' : 'Crear cita' }}
                        </h3>
                    </div>

                    <div class="px-4 py-4 sm:px-6 space-y-4">
                        <div class="grid grid-cols-1 gap-3 sm:grid-cols-2">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Fecha</label>
                                <input type="date" wire:model.defer="date" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" />
                                @error('date') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700">Hora</label>
                                <input type="time" wire:model.defer="time" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" />
                                @error('time') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                            </div>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700">Paciente</label>
                            <div x-data="{ open: false }" class="relative mt-1">
                                <!-- Input que muestra el nombre seleccionado o permite buscar -->
                                <div class="flex">
                                    <input
                                        type="text"
                                        class="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm"
                                        placeholder="Buscar paciente..."
                                        wire:model.live.debounce.300ms="patientSearch"
                                        x-on:focus="open = true"
                                        x-on:click.away="open = false"
                                        value="{{ $selectedPatientName }}"
                                    />
                                    @if($patient_id && 1==2)
                                        <button type="button" wire:click="$set('patient_id', null); $set('selectedPatientName', '')" class="ml-2 text-gray-400 hover:text-gray-600">
                                            <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" /></svg>
                                        </button>
                                    @endif
                                </div>

                                @if($selectedPatientName)
                                    <p class="mt-1 text-xs text-indigo-600 font-medium">Seleccionado: {{ $selectedPatientName }}</p>
                                @endif

                                <!-- Lista de resultados -->
                                <div
                                    x-show="open && $wire.patientSearch.length > 0"
                                    class="absolute z-10 mt-1 max-h-60 w-full overflow-auto rounded-md bg-white py-1 text-base shadow-lg ring-1 ring-black ring-opacity-5 focus:outline-none sm:text-sm"
                                    style="display: none;"
                                >
                                    @forelse($patients as $p)
                                        <button
                                            type="button"
                                            wire:click="selectPatient({{ $p->id }}, '{{ addslashes($p->name) }}')"
                                            x-on:click="open = false"
                                            class="relative w-full cursor-default select-none py-2 pl-3 pr-9 text-left text-gray-900 hover:bg-indigo-600 hover:text-white"
                                        >
                                            {{ $p->name }}
                                        </button>
                                    @empty
                                        <div class="py-2 pl-3 text-gray-500 italic">No se encontraron resultados...</div>
                                    @endforelse
                                </div>
                            </div>
                            @error('patient_id') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700">Sucursal</label>
                            <select wire:model.defer="branch_id" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" {{ auth()->user()->branch_id ? 'disabled' : '' }}>
                                <option value="">Seleccione...</option>
                                @foreach ($branches as $b)
                                    <option value="{{ $b->id }}">{{ $b->name }}</option>
                                @endforeach
                            </select>
                            @error('branch_id') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700">Tipo</label>
                            <select wire:model.defer="appointment_type_id" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <option value="">Seleccione...</option>
                                @foreach ($types as $t)
                                    <option value="{{ $t->id }}">{{ $t->name }}</option>
                                @endforeach
                            </select>
                            @error('appointment_type_id') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700">Primera visita</label>
                            <input type="checkbox" wire:model.defer="first_time" class="mt-1 block w-full rounded-lg border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" />
                            @error('first_time') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700">Notas</label>
                            <input type="text" wire:model.defer="note" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" />
                            @error('note') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
                        </div>



                        <div class="flex items-center gap-2">
                            <button
                                type="button"
                                wire:click="save"
                                class="inline-flex items-center justify-center rounded-md bg-indigo-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-indigo-500"
                            >
                                Guardar
                            </button>

                            <button
                                type="button"
                                wire:click="create"
                                class="inline-flex items-center justify-center rounded-md bg-white px-3 py-2 text-sm font-semibold text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-50"
                            >
                                Limpiar
                            </button>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

</div>

