<div class="p-4 space-y-6">
    <!-- Header y Filtros -->
    <div class="flex flex-wrap gap-4 items-end bg-white p-4 rounded-lg shadow-sm">
        <div class="w-64">
            <label class="block text-xs font-bold uppercase text-gray-500">Área</label>
            <select wire:model.live="selectedAreaId" class="w-full border-gray-300 rounded-md">
                @foreach($areas as $area)
                    <option value="{{ $area->id }}">{{ $area->name }}</option>
                @endforeach
            </select>
        </div>
        <div class="w-48">
            <label class="block text-xs font-bold uppercase text-gray-500">Fecha</label>
            <input type="date" wire:model.live="filterDate" class="w-full border-gray-300 rounded-md">
        </div>
        <button wire:click="refreshData" class="bg-gray-100 p-2 rounded hover:bg-gray-200">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path></svg>
        </button>
    </div>

    @if (session()->has('error'))
        <div class="bg-red-100 text-red-700 p-3 rounded-md">{{ session('error') }}</div>
    @endif

    <!-- Secciones de Listado -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- PENDIENTES -->
        <div class="bg-white rounded-lg shadow overflow-hidden">
            <div class="bg-yellow-50 px-4 py-2 border-b border-yellow-100 font-bold text-yellow-800">Pendientes de Iniciar</div>
            <table class="w-full text-sm">
                <thead><tr class="bg-gray-50 border-b">
                    <th class="p-2 text-left">Paciente</th>
                    <th class="p-2 text-left">Etapa</th>
                    <th class="p-2 text-center">Espera</th>
                    <th class="p-2"></th>
                </tr></thead>
                <tbody>
                @foreach($pendingStages as $s)
                    <tr class="border-b hover:bg-gray-50">
                        <td class="p-2 font-medium">{{ $s->appointment->patient->name }}</td>
                        <td class="p-2">{{ $s->concept_name }}</td>
                        <td class="p-2 text-center">
                            <span class="px-2 py-1 rounded {{ $s->wait_time > 10 ? 'bg-red-100 text-red-700' : 'bg-green-100 text-green-700' }}">
                                {{ $s->wait_time }} min
                            </span>
                        </td>
                        <td class="p-2 text-right">
                            <button wire:click="startStage({{ $s->id }})" class="bg-blue-600 text-white px-3 py-1 rounded text-xs hover:bg-blue-700">Iniciar</button>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>

        <!-- EN PROCESO -->
        <div class="bg-white rounded-lg shadow overflow-hidden">
            <div class="bg-blue-50 px-4 py-2 border-b border-blue-100 font-bold text-blue-800">Atendiendo Ahora</div>
            <table class="w-full text-sm">
                <thead><tr class="bg-gray-50 border-b">
                    <th class="p-2 text-left">Paciente</th>
                    <th class="p-2 text-left">Usuario</th>
                    <th class="p-2 text-center">Inicio</th>
                    <th class="p-2"></th>
                </tr></thead>
                <tbody>
                @foreach($inProgressStages as $s)
                    <tr class="border-b hover:bg-gray-50">
                        <td class="p-2 font-medium">{{ $s->appointment->patient->name }}</td>
                        <td class="p-2 text-xs text-gray-500">{{ $s->user->name }}</td>
                        <td class="p-2 text-center text-xs">{{ $s->started_at->format('H:i') }}</td>
                        <td class="p-2 text-right">
                            @if($s->user_id === auth()->id())
                                <button wire:click="openFinishModal({{ $s->id }})" class="bg-green-600 text-white px-3 py-1 rounded text-xs">Finalizar</button>
                            @else
                                <span class="text-gray-400 text-xs italic">Ocupado</span>
                            @endif
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <!-- MODAL DE FINALIZACIÓN (Tailwind) -->
    @if($showFinishModal)
        <div class="fixed inset-0 z-50 flex items-center justify-center bg-black bg-opacity-50">
            <div class="bg-white rounded-lg p-6 w-full max-w-md shadow-xl">
                <h3 class="text-lg font-bold mb-4">Finalizar Etapa</h3>

                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium">Observaciones</label>
                        <textarea wire:model="stageObservations" class="w-full border-gray-300 rounded-md h-24" placeholder="Escriba aquí..."></textarea>
                    </div>

                    @php
                        $isLastStage = !App\Models\AppointmentStage::where('appointment_id', App\Models\AppointmentStage::find($activeStageId)->appointment_id)
                            ->where('order', '>', App\Models\AppointmentStage::find($activeStageId)->order)->exists();
                    @endphp

                    @if($isLastStage)
                        <div class="bg-blue-50 p-3 rounded">
                            <label class="block text-sm font-bold text-blue-800">Descuento Final (Última Etapa)</label>
                            <select wire:model="selectedDiscount" class="w-full border-blue-300 rounded-md mt-1">
                                <option value="0">Sin descuento</option>
                                @foreach($discounts as $d)
                                    <option value="{{ $d->value }}">{{ $d->label }} ({{ $d->value }}%)</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="mt-4 border-t pt-4">
                            <label class="flex items-center gap-2 font-bold text-gray-700 cursor-pointer">
                                <input type="checkbox" wire:model.live="enableFollowUp" class="rounded">
                                Solicitar Seguimiento
                            </label>

                            @if($enableFollowUp)
                                <div class="mt-3 space-y-3 bg-gray-50 p-3 rounded">
                                    <div>
                                        <label class="block text-xs font-bold text-gray-500 uppercase">¿En cuánto tiempo?</label>
                                        <div class="grid grid-cols-2 gap-2 mt-1">
                                            @foreach($this->followUpOptions as $value => $label)
                                                <label class="flex items-center gap-2 text-sm cursor-pointer">
                                                    <input type="radio" wire:model="followUpOption" value="{{ $value }}"> {{ $label }}
                                                </label>
                                            @endforeach
                                        </div>
                                    </div>
                                    <div>
                                        <label class="block text-xs font-bold text-gray-500 uppercase">Motivo del seguimiento</label>
                                        <input type="text" wire:model="followUpReason" class="w-full border-gray-300 rounded-md text-sm" placeholder="Ej: Revisión de estudios">
                                        @error('followUpReason')
                                        <span class="text-red-500 text-xs mt-1">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            @endif
                        </div>
                    @endif
                </div>





                <div class="mt-6 flex justify-end gap-2">
                    <button wire:click="$set('showFinishModal', false)" class="px-4 py-2 text-gray-600">Cancelar</button>
                    <button wire:click="endStage" class="px-4 py-2 bg-green-600 text-white rounded hover:bg-green-700">Guardar y Terminar</button>
                </div>
            </div>
        </div>
    @endif
</div>
