<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="h-full bg-gray-100">
<head>
    <meta charset="utf-8">
    <title>@yield('title', config('app.name', 'POS'))</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="icon" type="image/x-icon" href="{{asset('assets/images/favicon.ico')}}">
    @vite(['resources/css/app.css','resources/js/app.js'])

    @livewireStyles
    @stack('head')
</head>
<body class="h-full">
<div class="min-h-full">
    <nav class="bg-gray-800">
        <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
            <div class="flex h-16 items-center justify-between">
                <div class="flex items-center min-w-0">
                    <div class="shrink-0 text-white font-semibold">
                        <a href="{{ route('pos') }}" class="flex items-center gap-2">
                            <img src="{{ asset('assets/images/isologo.png') }}" alt="Logo" class="h-12 w-auto">
                        </a>
                    </div>

                    <div class="hidden md:block">
                        <div class="ml-10 flex items-baseline space-x-4">


                            @if (\Illuminate\Support\Facades\Route::has('pos.appointments'))
                                <a
                                    href="{{ route('pos.appointments') }}"
                                    class="rounded-md px-3 py-2 text-sm font-medium text-gray-300 hover:bg-white/5 hover:text-white"
                                >
                                    Citas
                                </a>
                            @endif

                            @if (\Illuminate\Support\Facades\Route::has('pos.patients'))
                                <a
                                    href="{{ route('pos.patients') }}"
                                    class="rounded-md px-3 py-2 text-sm font-medium text-gray-300 hover:bg-white/5 hover:text-white"
                                >
                                    Pacientes
                                </a>
                            @endif

                                @if (\Illuminate\Support\Facades\Route::has('pos.sale-orders'))
                                    <a
                                        href="{{ route('pos.sale-orders') }}"
                                        class="rounded-md px-3 py-2 text-sm font-medium text-gray-300 hover:bg-white/5 hover:text-white"
                                    >
                                        Ventas
                                    </a>
                                @endif

                                @if (\Illuminate\Support\Facades\Route::has('appointments.tracker'))
                                    <a
                                        href="{{ route('appointments.tracker') }}"
                                        class="rounded-md px-3 py-2 text-sm font-medium text-gray-300 hover:bg-white/5 hover:text-white"
                                    >
                                        Seguimiento Citas
                                    </a>
                                @endif

                                <div x-data="{ open: false }" @click.away="open = false" class="relative">
                                    <button
                                        @click="open = !open"
                                        class="flex items-center gap-1 rounded-md px-3 py-2 text-sm font-medium text-gray-300 hover:bg-white/5 hover:text-white focus:outline-none"
                                    >
                                        <span>Reportes</span>
                                        <svg class="h-4 w-4 transition-transform" :class="open ? 'rotate-180' : ''" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                                        </svg>
                                    </button>

                                    <div
                                        x-show="open"
                                        x-transition:enter="transition ease-out duration-100"
                                        x-transition:enter-start="transform opacity-0 scale-95"
                                        x-transition:enter-end="transform opacity-100 scale-100"
                                        x-transition:leave="transition ease-in duration-75"
                                        x-transition:leave-start="transform opacity-100 scale-100"
                                        x-transition:leave-end="transform opacity-0 scale-95"
                                        style="display: none;"
                                        class="absolute left-0 mt-2 w-48 origin-top-left rounded-md bg-white py-1 shadow-lg ring-1 ring-black ring-opacity-5 z-50"
                                    >
                                        @if (\Illuminate\Support\Facades\Route::has('reports.payments'))
                                            <a href="{{ route('reports.payments') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                                Cobranza
                                            </a>
                                        @endif

                                            @if (\Illuminate\Support\Facades\Route::has('reports.sales'))
                                                <a href="{{ route('reports.sales') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                                    Ventas
                                                </a>
                                            @endif
                                        <!-- Aquí puedes agregar más reportes en el futuro -->
                                    </div>
                                </div>
                        </div>
                    </div>
                </div>

                <div class="hidden md:block">
                    <div class="ml-4 flex items-center md:ml-6 gap-3">
                        @auth
                            <span class="text-sm font-medium text-gray-200">
                                {{ auth()->user()->name ?? 'Usuario' }}
                            </span>

                            @if (\Illuminate\Support\Facades\Route::has('logout'))
                                <form method="POST" action="{{ route('logout') }}">
                                    @csrf
                                    <button
                                        type="submit"
                                        class="inline-flex items-center rounded-md bg-indigo-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-indigo-500 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-indigo-500"
                                    >
                                        Salir
                                    </button>
                                </form>
                            @endif
                        @endauth

                        @guest
                            @if (\Illuminate\Support\Facades\Route::has('login'))
                                <a
                                    href="{{ route('login') }}"
                                    class="inline-flex items-center rounded-md bg-indigo-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-indigo-500"
                                >
                                    Entrar
                                </a>
                            @endif
                        @endguest
                    </div>
                </div>

                <div class="-mr-2 flex md:hidden">
                    <details class="relative">
                        <summary class="list-none inline-flex items-center justify-center rounded-md p-2 text-gray-200 hover:bg-white/5 hover:text-white focus:outline-none">
                            <span class="sr-only">Abrir menú</span>
                            <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" aria-hidden="true" class="h-6 w-6">
                                <path d="M3.75 6.75h16.5M3.75 12h16.5m-16.5 5.25h16.5" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                        </summary>

                        <div class="absolute right-0 mt-2 w-56 origin-top-right rounded-md bg-white py-2 shadow-lg ring-1 ring-black/5 z-50">

                            @if (\Illuminate\Support\Facades\Route::has('pos.appointments'))
                                <a href="{{ route('pos.appointments') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                    Citas
                                </a>
                            @endif

                            @if (\Illuminate\Support\Facades\Route::has('pos.patients'))
                                <a href="{{ route('pos.patients') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                    Pacientes
                                </a>
                            @endif

                                @if (\Illuminate\Support\Facades\Route::has('pos.sale-orders'))
                                    <a href="{{ route('pos.sale-orders') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                        Ventas
                                    </a>
                                @endif



                                <div class="my-2 h-px bg-gray-100"></div>

                            @auth
                                <div class="px-4 pb-2 text-xs text-gray-500">
                                    {{ auth()->user()->name ?? 'Usuario' }}
                                </div>

                                @if (\Illuminate\Support\Facades\Route::has('logout'))
                                    <form method="POST" action="{{ route('logout') }}" class="px-4">
                                        @csrf
                                        <button
                                            type="submit"
                                            class="w-full rounded-md bg-indigo-600 px-3 py-2 text-left text-sm font-semibold text-white hover:bg-indigo-500"
                                        >
                                            Salir
                                        </button>
                                    </form>
                                @endif
                            @endauth

                            @guest
                                @if (\Illuminate\Support\Facades\Route::has('login'))
                                    <a href="{{ route('login') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                        Entrar
                                    </a>
                                @endif
                            @endguest
                        </div>
                    </details>
                </div>
            </div>
        </div>
    </nav>

    <main>
        <div class="mx-auto max-w-7xl px-4 py-6 sm:px-6 lg:px-8">
            @yield('content')
            {{ $slot ?? '' }}
        </div>
    </main>
</div>

@livewireScripts

<script>
    document.addEventListener('livewire:init', () => {
        Livewire.on('toast', (event) => {
            // Livewire 3 envía los parámetros directamente.
            // Esta lógica extrae el objeto 'data' sin importar cómo llegue.
            let data = event;
            if (Array.isArray(event)) data = event[0];
            if (event.detail) data = event.detail;

            // Verificación de seguridad antes de intentar leer 'message'
            if (data && data.message) {
                // Aquí puedes cambiar el alert por TallStackUI o SweetAlert2
                alert(data.message);
            } else {
                console.warn('Evento toast recibido con formato desconocido:', event);
            }
        });
    });

    Livewire.on('open-ticket', (event) => {
        const data = Array.isArray(event) ? event[0] : event;
        window.open(data.url, '_blank');
    });

</script>
@stack('scripts')
</body>
</html>
