<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class UserPermissionsSeeder extends Seeder
{
    public function run(): void
    {
        $guard = 'web';

        $permissions = [
            'users.viewAny',
            'users.view',
            'users.create',
            'users.update',
            'users.delete',
        ];

        foreach ($permissions as $name) {
            Permission::firstOrCreate(
                ['name' => $name, 'guard_name' => $guard],
                []
            );
        }

        $admin = Role::firstOrCreate(['name' => 'Admin', 'guard_name' => $guard]);
        $user = Role::firstOrCreate(['name' => 'User', 'guard_name' => $guard]);

        $admin->givePermissionTo($permissions);
        $user->givePermissionTo(['users.viewAny', 'users.view']);
    }
}
