<?php
namespace Database\Seeders;
use App\Models\AppointmentType;
use Illuminate\Database\Seeder;

class AppointmentTypesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $appointmentType = AppointmentType::create(
            ['name' => 'General',
                'related_product_id' => 1]);

        $appointmentType->steps()->createMany([
            ['name' => 'Registra llegada', 'expected_time' => 1, 'order' => 0],
            ['name' => 'Genera folio', 'expected_time' => 1, 'order' => 1],
            ['name' => 'Pregunta y captura de datos Meisel', 'expected_time' => 6, 'order' => 2],
            ['name' => 'Revisar Cuestionario MediSel por fellow', 'expected_time' => 1, 'order' => 3],
            ['name' => 'Toma de Agudeza visual', 'expected_time' => 5, 'order' => 4],
            ['name' => 'Autore fracción', 'expected_time' => 3, 'order' => 5],
            ['name' => 'Toma de signos vitales', 'expected_time' => 3, 'order' => 6],
            ['name' => 'Registrar  datos clinicos MS', 'expected_time' => 5, 'order' => 7],
            ['name' => 'Registrar  datos generales MS', 'expected_time' => 10, 'order' => 8],
            ['name' => 'Exploración inicial por fellow', 'expected_time' => 5, 'order' => 9],
            ['name' => 'Exploración al paciente', 'expected_time' => 20, 'order' => 10],
            ['name' => 'Realiza receta / seguimiento', 'expected_time' => 2, 'order' => 11],
            ['name' => 'Finalizar consulta / Despedida', 'expected_time' => 3, 'order' => 12]

        ]);
    }
}
