<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('appointment_follow_ups', function (Blueprint $table) {
            $table->id();
            $table->foreignId('patient_id')->index();
            $table->foreignId('appointment_id')->nullable()->index();
            $table->date('due_date');
            $table->string('reason');
            $table->enum('status', ['open', 'closed'])->default('open');
            $table->text('closing_observations')->nullable();
            $table->dateTime('closed_at')->nullable();
            $table->foreignId('closed_by')->nullable()->nullable()->index();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('appointment_follow_ups');
    }
};
