<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('appointment_type_concepts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('appointment_type_id')->index();
            $table->unsignedBigInteger('appointment_concept_id')->index();
            $table->decimal('expected_time',10,2);
            $table->decimal('maximum_time',10,2);
            $table->integer('order')->nullable();
            $table->boolean('enabled');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('appointment_type_concepts');
    }
};
