<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSaleOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sale_orders', function (Blueprint $table) {
            $table->id();
            $table->date('date')->nullable();
            $table->string('number')->nullable();
            $table->boolean('first_time')->default(0);
            $table->unsignedBigInteger('patient_id')->nullable()->index();
            $table->unsignedBigInteger('branch_id')->nullable()->index();
            //$table->foreign('patient_id')->references('id')->on('patients');
            $table->decimal('subtotal', 10, 2)->default(0);
            $table->decimal('discount', 10, 2)->default(0);
            $table->decimal('tax', 10, 2)->default(0);
            $table->decimal('total', 10, 2)->default(0);
            $table->enum('payment_status', ['created','open', 'paid','cancel'])->default('created');
            $table->integer('odoo_server')->nullable();
            $table->string('odoo_sale_order_id')->nullable();
            $table->string('odoo_sale_order_number')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->string('created_by_name')->nullable();
            $table->timestamps();
        });

        Schema::create('sale_order_lines', function (Blueprint $table)
    {
        $table->id();
        $table->unsignedBigInteger('sale_order_id');
        $table->foreign('sale_order_id')->references('id')->on('sale_orders');
        $table->unsignedBigInteger('product_id')->nullable();
        $table->string('product_name')->nullable()->index();
       // $table->foreign('product_id')->references('id')->on('products');
        $table->integer('quantity')->default(1);
        $table->decimal('price',10,2)->default(0);
        $table->decimal('discount', 10, 2)->default(0);
        $table->decimal('tax', 10, 2)->default(0);
        $table->decimal('amount',10,2)->default(0);
        $table->timestamps();

    });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sale_orders');
    }
}
