<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAppointmentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('appointments', function (Blueprint $table) {
            $table->id();
            $table->date('date');
            $table->time('time');
            $table->unsignedBigInteger('branch_id')->nullable()->index();
            $table->unsignedBigInteger('patient_id');
            $table->foreign('patient_id')
                ->on('patients')
                ->references('id');
            $table->unsignedBigInteger('appointment_type_id')->nullable()->index();
            $table->unsignedBigInteger('appointment_category_id')->nullable()->index();
            $table->unsignedBigInteger('appointment_class_id')->nullable()->index();
            $table->unsignedBigInteger('appointment_shape_id')->nullable()->index();

            $table->enum('status',['Creada','Agendada','En Proceso','Finalizada','Documentada','Cancelada']);
            $table->string('note')->nullable();
            $table->string('prescription_note')->nullable();
            $table->timestamps();
        });

        Schema::create('appointment_steps', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('appointment_id');
            $table->foreign('appointment_id')
                ->on('appointments')
                ->references('id');
            $table->string('name');
            $table->integer('expected_time')->default(30);
            $table->integer('order')->nullable();
            $table->datetime('start_at')->nullable();
            $table->datetime('end_at')->nullable();
            $table->integer('real_time')->default(0);
            $table->string('status')->default('Esperando');
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('appointments');
        Schema::dropIfExists('appointment_steps');
    }
}
