<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSurgeryChecklists extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('surgery_checklists', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('surgery_id');
            $table->foreign('surgery_id')->on('surgeries')->references('id')->onDelete('restrict');

            //PreOperatorio

            $table->boolean('q10_1_boolean')->default(0);
            $table->boolean('q10_2_boolean')->default(0);
            $table->boolean('q10_3_boolean')->default(0);
            $table->date('q10_4_date')->nullable();

            $table->enum('q11_1_enum',['Quimica Sanguinea', 'Cardiovasculares'.'Tiempos de coagulación'])->nullable();
            $table->date('q11_2_date')->nullable();

            $table->enum('q12_1_enum',['Monofocal', 'Multifocal','Torico'])->nullable();
            $table->enum('q12_2_enum',['Local', 'General Vigilada'])->nullable();
            $table->unsignedBigInteger('q12_3_integer')->nullable(); //related with surgery type
            $table->unsignedBigInteger('q12_4_integer')->nullable(); //related with medical team members where mtm.type=Cirujano
            $table->boolean('q12_5_boolean')->default(0);

            $table->string('q13_1_string')->nullable();
            $table->string('q13_2_string')->nullable();
            $table->string('q13_3_string')->nullable();
            $table->string('q13_4_string')->nullable();
            $table->string('q13_5_string')->nullable();

            $table->boolean('q13_6_boolean')->default(0);
            $table->boolean('q13_7_boolean')->default(0);
            $table->boolean('q13_8_boolean')->default(0);
            $table->string('q13_8a_string')->nullable();
            $table->boolean('q13_9_boolean')->default(0);
            $table->boolean('q13_10_boolean')->default(0);

            $table->boolean('q20_1_boolean')->default(0);
            $table->boolean('q20_2_boolean')->default(0);
            $table->boolean('q20_3_boolean')->default(0);
            $table->boolean('q20_4_boolean')->default(0);
            $table->boolean('q20_5_boolean')->default(0);
            $table->boolean('q20_6_boolean')->default(0);

            $table->boolean('q30_1_boolean')->default(0);
            $table->boolean('q30_2_boolean')->default(0);
            $table->boolean('q30_3_boolean')->default(0);

            $table->string('observations')->nullable();

            $table->string('filled_by')->nullable();
            $table->binary('filled_by_signature')->nullable();

            $table->string('audited_by')->nullable();
            $table->binary('audited_by_signature')->nullable();
            $table->string('audited_comments')->nullable();

            $table->string('doctor_name')->nullable();
            $table->binary('doctor_signature')->nullable();

            $table->string('patient_name')->nullable();
            $table->binary('patient_signature')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('surgery_checklists');
    }
}
