<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSurgeriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('surgeries', function (Blueprint $table) {
            $table->id();
            $table->dateTime('date');
            $table->unsignedBigInteger('patient_id');
            $table->foreign('patient_id')
                ->on('patients')
                ->references('id');
            $table->unsignedBigInteger('surgery_type_id')->nullable()->index();
            $table->unsignedBigInteger('insurance_carrier_id')->index()->nullable();
            $table->unsignedBigInteger('surgery_modality_id')->index()->nullable();

            $table->unsignedBigInteger('surgeon_id')->index()->nullable();
            $table->decimal('surgeon_fee',10,2)->default(0.00);
            $table->boolean('surgeon_fee_paid')->default(0);
            $table->unsignedBigInteger('anesthetist_id')->index()->nullable();
            $table->decimal('anesthetist_fee',10,2)->default(0.00);
            $table->boolean('anesthetist_fee_paid')->default(0);
            $table->unsignedBigInteger('assistant_id')->index()->nullable();
            $table->decimal('assistant_fee',10,2)->default(0.00);
            $table->boolean('assistant_fee_paid')->default(0);
            $table->unsignedBigInteger('nurse_id')->index()->nullable();
            $table->decimal('nurse_fee',10,2)->default(0.00);
            $table->boolean('nurse_fee_paid')->default(0);
            $table->decimal('hospital_fee',10,2)->default(0.00);
            $table->boolean('hospital_fee_paid')->default(0);

            $table->enum('status',['Creada','Agendada','En Proceso','Finalizada','Cancelada']);
            $table->timestamps();
        });
        Schema::create('surgery_steps', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('surgery_id');
            $table->foreign('surgery_id')
                ->on('surgeries')
                ->references('id');
            $table->integer('expected_time')->default(30);
            $table->datetime('start_at')->nullable();
            $table->datetime('end_at')->nullable();
            $table->integer('real_time')->default(0);
            $table->string('status')->default('Esperando');
            $table->timestamps();
        });


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('surgeries');
        Schema::dropIfExists('surgery_steps');
    }
}
