<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSurgeryTypesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('surgery_types', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->boolean('active')->default(1);
            $table->timestamps();
        });

        Schema::create('surgery_type_steps', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('surgery_type_id');
            $table->foreign('surgery_type_id')
                ->on('surgery_types')
                ->references('id')
                ->onDelete('cascade');
            $table->string('name');
            $table->integer('expected_time')->default(30);
            $table->boolean('active')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('surgery_types');
        Schema::dropIfExists('surgery_type_steps');
    }
}
