<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAppointmentTypesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('appointment_types', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->unsignedBigInteger('related_product_id')->index();
            $table->boolean('active')->default(1);
            $table->timestamps();
        });

        Schema::create('appointment_type_steps', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('appointment_type_id');
            $table->foreign('appointment_type_id')
                ->on('appointment_types')
                ->references('id')
                ->onDelete('cascade');
            $table->string('name');
            $table->integer('expected_time')->default(30);
            $table->integer('order')->nullable();
            $table->boolean('minimum_required')->nullable();
            $table->boolean('active')->default(1);
            $table->timestamps();
        });


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('appointment_types');
        Schema::dropIfExists('appointment_type_steps');
    }
}
