<?php

return [
    // Resource key => [model FQCN, label, fields (list + form)]
    // Only whitelisted resources are accessible.
    'patients' => [
        'model' => App\Patient::class,
        'label' => 'Patients',
        'fields' => [
            'name' => 'text',
            'birthday' => 'date',
            'profession' => 'number',
            'gender' => 'select:HOMBRE,MUJER',
            'company_name' => 'text',
            'tin' => 'text',
            'phone' => 'text',
            'mobile' => 'text',
            'email' => 'email',
        ],
    ],
    'appointments' => [
        'model' => App\Appointment::class,
        'label' => 'Appointments',
        'fields' => [
            'date' => 'date',
            'time' => 'time',
            'patient_id' => 'number',
            'branch_id' => 'number',
            'appointment_type_id' => 'number',
            'appointment_category_id' => 'number',
            'appointment_class_id' => 'number',
            'appointment_shape_id' => 'number',
            'status' => 'text',
            'note' => 'textarea',
            'prescription_note' => 'textarea',
        ],
    ],
    'appointment-types' => [
        'model' => App\AppointmentType::class,
        'label' => 'Appointment Types',
        'fields' => [
            'name' => 'text',
            'related_product_id' => 'number',
            'active' => 'checkbox',
        ],
    ],
    'products' => [
        'model' => App\Product::class,
        'label' => 'Products',
        'fields' => [
            'name' => 'text',
            'list_price' => 'number:step=0.01',
            'taxes' => 'checkbox',
            'active' => 'checkbox',
            'business_unit_id' => 'number',
        ],
    ],
    'sale-orders' => [
        'model' => App\SaleOrder::class,
        'label' => 'Sale Orders',
        'fields' => [
            'date' => 'date',
            'number' => 'text',
            'first_time' => 'checkbox',
            'patient_id' => 'number',
            'branch_id' => 'number',
            'subtotal' => 'number:step=0.01',
            'discount' => 'number:step=0.01',
            'tax' => 'number:step=0.01',
            'total' => 'number:step=0.01',
            'payment_status' => 'select:created,open,paid,cancel',
            'created_by' => 'number',
            'created_by_name' => 'text',
        ],
    ],
    'sale-order-lines' => [
        'model' => App\SaleOrderLine::class,
        'label' => 'Sale Order Lines',
        'fields' => [
            'sale_order_id' => 'number',
            'product_id' => 'number',
            'product_name' => 'text',
            'quantity' => 'number',
            'price' => 'number:step=0.01',
            'discount' => 'number:step=0.01',
            'tax' => 'number:step=0.01',
            'amount' => 'number:step=0.01',
        ],
    ],
    'payments' => [
        'model' => App\Payment::class,
        'label' => 'Payments',
        'fields' => [
            'sale_order_id' => 'number',
            'user_id' => 'number',
            'type' => 'select:advance,payment',
            'amount' => 'number:step=0.01',
            'method' => 'select:cash,card,check,transfer,codi,other',
            'reference' => 'text',
            'status' => 'select:created,confirmed,canceled',
        ],
    ],
    'branches' => [
        'model' => App\Branch::class,
        'label' => 'Branches',
        'fields' => [
            'name' => 'text',
            'address' => 'text',
            'address2' => 'text',
            'city' => 'text',
            'state' => 'text',
            'country' => 'text',
            'zip' => 'text',
            'phone' => 'text',
            'email' => 'email',
            'invoice_prefix' => 'text',
            'sale_order_prefix' => 'text',
        ],
    ],
    'config-databases' => [
        'model' => App\ConfigDatabase::class,
        'label' => 'Servers',
        'fields' => [
            'host' => 'text',
            'database' => 'text',
            'client_id' => 'text',
            'client_secret' => 'text',
        ],
    ],
    'appointment-prescription-items' => [
        'model' => App\AppointmentPrescriptionItem::class,
        'label' => 'Appointment Prescription Items',
        'fields' => [
            'appointment_id' => 'number',
            'product' => 'text',
            'instructions' => 'textarea',
            'bought' => 'checkbox',
        ],
    ],
    'system-discounts' => [
        'model' => App\SystemDiscount::class,
        'label' => 'System Discounts',
        'fields' => [
            'value' => 'number',
            'label' => 'text',
        ],
    ],
    'user-tokens' => [
        'model' => App\Models\UserToken::class,
        'label' => 'User Tokens',
        'fields' => [
            'user_id' => 'number',
            'server_id' => 'text',
            'access_token' => 'text',
            'expires_at' => 'datetime',
            'refreshToken' => 'text',
        ],
    ],
];
