<?php

namespace App\Services\Odoo;

use App\Models\ConfigDatabase;
use App\Models\UserToken;
use League\OAuth2\Client\Provider\GenericProvider;

interface OdooApiInterface
{
    public function getProvider(ConfigDatabase $server): GenericProvider;

    public function getToken(string $username, string $password, ConfigDatabase $server): UserToken;

    public function userInfo(string $token, array $options, ConfigDatabase $server): array;

    public function searchRead(string $model, string $token, array $parameters, ConfigDatabase $server): array;

    public function read(string $model, string $token, array $parameters, ConfigDatabase $server): array;

    public function create(string $model, string $token, array $payload, ConfigDatabase $server): array;

    public function write(string $model, string $token, array $payload, ConfigDatabase $server): array;
}
