<?php

namespace App\Providers;
use App\Services\Odoo\OdooApiInterface;
use App\Services\Odoo\OdooApiService;
use GuzzleHttp\Client;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->app->singleton(OdooApiInterface::class, function ($app) {
            return new OdooApiService(
                apiHost: config('services.odoo.host', 'erp.glaucoma.mx:8069'),
                http: new Client(['verify' => false])
            );
        });
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }
}
