<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AppointmentTypeConcept extends Model
{
    protected $fillable = [
        'appointment_type_id',
        'appointment_concept_id',
        'expected_time',
        'maximum_time',
        'order',
        'enabled',
    ];

    public function appointmentType(): BelongsTo
    {
        return $this->belongsTo(AppointmentType::class);
    }

    public function appointmentConcept(): BelongsTo
    {
        return $this->belongsTo(AppointmentConcept::class);
    }

    protected function casts(): array
    {
        return [
            'enabled' => 'boolean',
        ];
    }
}
