<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AppointmentStage extends Model
{
    protected $fillable = [
        'appointment_id',
        'appointment_type_concept_id',
        'area_id',
        'user_id',
        'concept_name',
        'started_at',
        'ended_at',
        'duration_minutes',
        'observations',
        'order'
    ];

    protected $casts = [
        'started_at' => 'datetime',
        'ended_at' => 'datetime',
    ];

    // Constante para habilitar/deshabilitar restricción de orden
    const REQUIRE_PREVIOUS_FINISHED = true;

    public function appointment(): BelongsTo
    {
        return $this->belongsTo(Appointment::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function area(): BelongsTo
    {
        return $this->belongsTo(Area::class);
    }
}
