<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Appointment extends Model
{
    protected $fillable = [
        'date','time', 'patient_id','branch_id', 'appointment_type_id','first_time',
        'appointment_category_id', 'appointment_class_id', 'appointment_shape_id',
        'status', 'discount_value', 'started_at', 'ended_at', 'total_duration_minutes',
        'sale_order_id'
    ];

    protected $casts = [
        'first_time' => 'boolean',
        'started_at' => 'datetime',
        'ended_at' => 'datetime',
        'date' => 'date',
    ];

    public function patient(){
        return $this->belongsTo(Patient::class);
    }
    public function type(){
        return $this->belongsTo(AppointmentType::class, 'appointment_type_id','id');
    }
    public function steps()
    {
        return $this->hasMany(AppointmentStep::class);
    }

    public function stages()
    {
        return $this->hasMany(AppointmentStage::class);
    }

    public function prescriptionItems()
    {
        return $this->hasMany(AppointmentPrescriptionItem::class);
    }

    public function saleOrder()
    {
        return $this->belongsTo(SaleOrder::class);
    }
}
