<?php

namespace App\Livewire\Reports\Payments;

use App\Models\Payment;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class PaymentsReport extends Component
{
    public $startDate;
    public $endDate;

    public function mount()
    {
        // Por defecto, mostramos lo de hoy
        $this->startDate = Carbon::today()->toDateString();
        $this->endDate = Carbon::today()->toDateString();
    }

    public function render()
    {
        $query = Payment::query()
            ->where('user_id', Auth::id())
            ->whereBetween('created_at', [
                Carbon::parse($this->startDate)->startOfDay(),
                Carbon::parse($this->endDate)->endOfDay()
            ])
            ->with('saleOrder:id,number');

        $payments = $query->get();
        $total = $payments->sum('amount');
        $total_cash = $payments->where('method', 'cash')->sum('amount');

        return view('livewire.reports.payments.payments_report', [
            'payments' => $payments,
            'total' => $total,
            'total_cash' => $total_cash,
        ]);
    }
}
