<?php

namespace App\Livewire;

use App\Models\Appointment;
use App\Models\AppointmentFollowUp;
use App\Models\Patient;
use App\Models\Payment;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;
use Carbon\Carbon;
use Livewire\WithPagination;

class Dashboard extends Component
{
    use WithPagination;
    public int $totalPatients = 0;
    public int $totalAppointments = 0;
    public int $appointmentsTodayCount = 0;
    public int $appointmentsYesterdayCount = 0;
    public float $todayPaymentsSum = 0.0;

    public $showCloseModal = false;
    public $activeFollowUpId;
    public $closingObservations = '';


    //Follow Ups

    public function openCloseModal($id)
    {
        $this->activeFollowUpId = $id;
        $this->closingObservations = '';
        $this->showCloseModal = true;
    }

    public function closeFollowUp()
    {
        $followUp = AppointmentFollowUp::findOrFail($this->activeFollowUpId);
        $followUp->update([
            'status' => 'closed',
            'closing_observations' => $this->closingObservations,
            'closed_at' => now(),
            'closed_by' => Auth::id()
        ]);

        $this->showCloseModal = false;
        $this->dispatch('toast', type: 'success', message: 'Seguimiento cerrado.');
    }

    public function mount(): void
    {
        $user = Auth::user();
        $today = Carbon::today();
        $yesterday = Carbon::yesterday();

        // 1. Resumen de cantidad de pacientes
        $this->totalPatients = Patient::count();

        // 2. Total de citas (histórico)
        $this->totalAppointments = Appointment::count();

        // 6. Comparativo de citas Hoy vs Ayer (por sucursal del usuario)
        if ($user->branch_id) {
            $this->appointmentsTodayCount = Appointment::where('branch_id', $user->branch_id)
                ->whereDate('date', $today)
                ->count();

            $this->appointmentsYesterdayCount = Appointment::where('branch_id', $user->branch_id)
                ->whereDate('date', $yesterday)
                ->count();
        }
    }

    public function render()
    {
        $user = Auth::user();
        $today = Carbon::today();

        // 3. Listado de citas de hoy (asignadas al usuario o en su sucursal hoy)
        // Nota: En tu requerimiento pides user_id, lo aplicamos a la cita.
        $todayAppointments = Appointment::with('patient', 'type')
            ->whereDate('date', $today)
            ->where('branch_id', $user->branch_id)
            ->orderBy('time')
            ->paginate(10, pageName: 'appointments-page');

        // 4. Listado de pagos recibidos hoy por el usuario autenticado
        $todayPayments = Payment::with('saleOrder.patient')
            ->where('user_id', $user->id)
            ->whereDate('created_at', $today)
            ->orderByDesc('created_at')
            ->paginate(10, pageName: 'payments-page');

        $this->todayPaymentsSum = $todayPayments->sum('amount');
// To DO List
        $pendingFollowUps = AppointmentFollowUp::with(['patient', 'appointment'])
            ->where('status', 'open')
            ->orderBy('due_date', 'asc')
            ->get();

        return view('livewire.dashboard', [
            'todayAppointments' => $todayAppointments,
            'todayPayments' => $todayPayments,
            'pendingFollowUps' => $pendingFollowUps
        ]);
    }
}
