<?php

namespace App\Filament\Resources;

use App\Filament\Resources\SystemDiscountResource\Pages;
use App\Models\SystemDiscount;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteAction;
use Filament\Tables\Actions\DeleteBulkAction;
use Filament\Tables\Actions\EditAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class SystemDiscountResource extends Resource
{
    protected static ?string $model = SystemDiscount::class;

    protected static ?string $slug = 'descuentos';

    protected static ?string $navigationIcon = 'heroicon-o-percent-badge';
    protected static ?string $pluralModelLabel = 'Descuentos';
    protected static ?string $modelLabel = 'Descuento';

    protected static ?string $navigationGroup = 'Configuración';
    protected static ?string $navigationLabel = 'Descuentos';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                TextInput::make('value')
                    ->label('Valor')
                    ->required()
                    ->numeric(),
                TextInput::make('label')
                    ->label('Etiqueta')
                    ->required()
                    ->maxLength(191),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('value')->label('Valor')->searchable()->sortable(),
                TextColumn::make('label')->label('Etiqueta')->searchable()->sortable(),
            ])
            ->filters([
                //
            ])
            ->actions([
                EditAction::make(),
                DeleteAction::make(),
            ])
            ->bulkActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListSystemDiscounts::route('/'),
            'create' => Pages\CreateSystemDiscount::route('/create'),
            'edit' => Pages\EditSystemDiscount::route('/{record}/edit'),
        ];
    }

    public static function getGloballySearchableAttributes(): array
    {
        return [];
    }
}
