<?php

namespace App\Filament\Resources\RoleResource\Pages;

use App\Filament\Resources\RoleResource;
use Filament\Resources\Pages\EditRecord;

class EditRole extends EditRecord
{
    protected static string $resource = RoleResource::class;

    protected function mutateFormDataBeforeFill(array $data): array
    {
        $data['permissions'] = $this->record->permissions?->pluck('name')->all() ?? [];
        return $data;
    }

    protected function afterSave(): void
    {
        $perms = (array) ($this->form->getState()['permissions'] ?? []);
        $this->record->syncPermissions($perms);
    }
}
