<?php

namespace App\Filament\Resources\RoleResource\Pages;

use App\Filament\Resources\RoleResource;
use Filament\Resources\Pages\CreateRecord;

class CreateRole extends CreateRecord
{
    protected static string $resource = RoleResource::class;

    protected function afterCreate(): void
    {
        $perms = (array) ($this->form->getState()['permissions'] ?? []);
        if (! empty($perms)) {
            $this->record->syncPermissions($perms);
        }
    }
}
