<?php

namespace App\Filament\Resources\ProductResource\Pages;

use App\Filament\Resources\ProductResource;
use App\Services\ProductService;
use Filament\Notifications\Notification;
use Filament\Pages\Actions\Action;
use Filament\Resources\Pages\ListRecords;

class ListProducts extends ListRecords
{
    protected static string $resource = ProductResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Action::make('syncProducts')
                ->label('Sincronizar productos')
                ->icon('heroicon-o-arrow-path')
                ->requiresConfirmation()
                ->action(function (ProductService $sync) {
                    $count = $sync->syncAllServers();
                    Notification::make()
                        ->title("Sincronización completada")
                        ->body("Productos procesados: {$count}")
                        ->success()
                        ->send();
                }),
        ];
    }
}
