<?php

namespace App\Filament\Resources;

use App\Filament\Resources\ConfigDatabaseResource\Pages;
use App\Models\ConfigDatabase;
use Filament\Forms\Components\Grid;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteAction;
use Filament\Tables\Actions\DeleteBulkAction;
use Filament\Tables\Actions\EditAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class ConfigDatabaseResource extends Resource
{
    protected static ?string $model = ConfigDatabase::class;

    protected static ?string $slug = 'servers';

    protected static ?string $navigationIcon = 'heroicon-o-server';
    protected static ?string $navigationGroup = 'Configuración';
    protected static ?string $navigationLabel = 'Servidores';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make('Database config')
                    ->schema([
                        Grid::make(2)->schema([

                            TextInput::make('host')
                                ->label('Host')
                                ->required()
                                ->maxLength(191),

                            TextInput::make('database')
                                ->label('Database')
                                ->required()
                                ->maxLength(191),
                        ]),
                        Grid::make(2)->schema([
                            TextInput::make('client_id')
                                ->label('Cient ID')
                                ->password()
                                ->revealable()
                                ->maxLength(191),
                            TextInput::make('client_secret')
                                ->label('Secret')
                                ->password()
                                ->revealable()
                                ->maxLength(191),
                        ]),

                    ]),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('host')->label('Host')->searchable()->sortable(),
                TextColumn::make('database')->label('Database')->searchable()->sortable(),
                TextColumn::make('created_at')->label('Created')->dateTime()->since()->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                EditAction::make(),
                DeleteAction::make(),
            ])
            ->bulkActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListConfigDatabases::route('/'),
            'create' => Pages\CreateConfigDatabase::route('/create'),
            'edit' => Pages\EditConfigDatabase::route('/{record}/edit'),
        ];
    }

    public static function getGloballySearchableAttributes(): array
    {
        return ['host', 'database'];
    }
}
