<?php

namespace App\Filament\Resources;

use App\Filament\Resources\AppointmentConceptResource\Pages;
use App\Models\AppointmentConcept;
use Filament\Forms\Components\Placeholder;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteAction;
use Filament\Tables\Actions\DeleteBulkAction;
use Filament\Tables\Actions\EditAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

class AppointmentConceptResource extends Resource
{
    protected static ?string $model = AppointmentConcept::class;

    protected static ?string $slug = 'appointment-concepts';
    protected static ?string $navigationGroup = 'Configuración';

    protected static ?string $navigationIcon = 'heroicon-o-chevron-up';

    protected static ?string $navigationLabel = 'Conceptos de Cita';
    protected static ?string $pluralModelLabel = 'Conceptos de Cita';
    protected static ?string $modelLabel = 'Concepto de Cita';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                TextInput::make('name')
                    ->required(),

                Select::make('area_id')
                    ->relationship('area', 'name')
                    ->searchable()
                    ->required(),

                Placeholder::make('created_at')
                    ->label('Created Date')
                    ->content(fn(?AppointmentConcept $record): string => $record?->created_at?->diffForHumans() ?? '-'),

                Placeholder::make('updated_at')
                    ->label('Last Modified Date')
                    ->content(fn(?AppointmentConcept $record): string => $record?->updated_at?->diffForHumans() ?? '-'),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('name')
                    ->searchable()
                    ->sortable(),

                TextColumn::make('area.name')
                    ->searchable()
                    ->sortable(),
            ])
            ->filters([
                //
            ])
            ->actions([
                EditAction::make(),
                DeleteAction::make(),
            ])
            ->bulkActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListAppointmentConcepts::route('/'),
            'create' => Pages\CreateAppointmentConcept::route('/create'),
            'edit' => Pages\EditAppointmentConcept::route('/{record}/edit'),
        ];
    }

    /**
     * @return Builder<AppointmentConcept>
     */
    public static function getGlobalSearchEloquentQuery(): Builder
    {
        return parent::getGlobalSearchEloquentQuery()->with(['area']);
    }

    public static function getGloballySearchableAttributes(): array
    {
        return ['name', 'area.name'];
    }

    /**
     * @param AppointmentConcept $record
     */
    public static function getGlobalSearchResultDetails(Model $record): array
    {
        $details = [];

        if ($record->area) {
            $details['Area'] = $record->area->name;
        }

        return $details;
    }
}
